/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.octo;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.MediaType;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;

public class OctoEndpoint
extends AbstractEndpoint {
    OctoEndpoint(Conference conference, String id) {
        super(conference, id);
    }

    @Override
    public void sendMessage(String msg) {
    }

    @Override
    protected void maybeExpire() {
        Object[] audioTracks = this.getMediaStreamTracks(MediaType.AUDIO);
        Object[] videoTracks = this.getMediaStreamTracks(MediaType.VIDEO);
        if (ArrayUtils.isNullOrEmpty((Object[])audioTracks) && ArrayUtils.isNullOrEmpty((Object[])videoTracks)) {
            this.expire();
        }
    }

    List<MediaStreamTrackDesc> getMediaStreamTracks() {
        LinkedList<MediaStreamTrackDesc> tracks = new LinkedList<MediaStreamTrackDesc>();
        tracks.addAll(Arrays.asList(this.getMediaStreamTracks(MediaType.AUDIO)));
        tracks.addAll(Arrays.asList(this.getMediaStreamTracks(MediaType.VIDEO)));
        return tracks;
    }

    @Override
    public MediaStreamTrackDesc[] getMediaStreamTracks(MediaType mediaType) {
        String id = this.getID();
        return (MediaStreamTrackDesc[])this.getAllMediaStreamTracks(mediaType).stream().filter(track -> id.equals(track.getOwner())).toArray(MediaStreamTrackDesc[]::new);
    }
}

