/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.configuration;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import net.java.sip.communicator.impl.configuration.JdbcConfigService;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ConfigurationActivator
implements BundleActivator {
    public static final String PNAME_USE_PROPFILE_CONFIG = "net.java.sip.communicator.impl.configuration.USE_PROPFILE_CONFIG";
    private static final Logger logger = Logger.getLogger(ConfigurationActivator.class);
    private ConfigurationService cs;

    public void start(BundleContext bundleContext) throws Exception {
        if (this.usePropFileConfigService(bundleContext)) {
            logger.info((Object)"Using properties file configuration store.");
            this.cs = LibJitsi.getConfigurationService();
        } else {
            this.cs = new JdbcConfigService((FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class));
        }
        bundleContext.registerService(ConfigurationService.class.getName(), (Object)this.cs, null);
        ConfigurationActivator.fixPermissions(this.cs);
    }

    private boolean usePropFileConfigService(BundleContext bundleContext) {
        if (Boolean.getBoolean(PNAME_USE_PROPFILE_CONFIG)) {
            return true;
        }
        FileAccessService fas = (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
        if (fas == null) {
            return true;
        }
        try {
            return fas.getPrivatePersistentFile(".usepropfileconfig", FileCategory.PROFILE).exists();
        }
        catch (Exception ise) {
            return true;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.cs.storeConfiguration();
        this.cs = null;
    }

    private static void fixPermissions(ConfigurationService cs) {
        block5: {
            if (!OSUtils.IS_LINUX && !OSUtils.IS_MAC) {
                return;
            }
            try {
                File cf;
                File homeFolder = new File(cs.getScHomeDirLocation(), cs.getScHomeDirName());
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(){
                    {
                        this.add(PosixFilePermission.OWNER_READ);
                        this.add(PosixFilePermission.OWNER_WRITE);
                        this.add(PosixFilePermission.OWNER_EXECUTE);
                    }
                };
                Files.setPosixFilePermissions(Paths.get(homeFolder.getAbsolutePath(), new String[0]), (Set<PosixFilePermission>)perms);
                String fileName = cs.getConfigurationFilename();
                if (fileName != null && (cf = new File(homeFolder, fileName)).exists()) {
                    perms = new HashSet<PosixFilePermission>(){
                        {
                            this.add(PosixFilePermission.OWNER_READ);
                            this.add(PosixFilePermission.OWNER_WRITE);
                        }
                    };
                    Files.setPosixFilePermissions(Paths.get(cf.getAbsolutePath(), new String[0]), (Set<PosixFilePermission>)perms);
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error creating c lib instance for fixing file permissions", t);
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)t;
            }
        }
    }
}

