/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public abstract class AbstractGainControl
implements GainControl {
    private final List<GainChangeListener> listeners = new ArrayList<GainChangeListener>();
    private boolean mute;
    private float savedLevelDuringMute;

    protected static float dBToLevel(float db) {
        return (float)Math.pow(10.0, (double)db / 20.0);
    }

    protected static float levelToDb(float level) {
        return (float)(Math.log10(level) * 20.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGainChangeListener(GainChangeListener listener) {
        List<GainChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    @Override
    public Component getControlComponent() {
        return null;
    }

    @Override
    public float getDB() {
        return AbstractGainControl.levelToDb(this.getLevel());
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    protected float getSavedLevelDuringMute() {
        return this.savedLevelDuringMute;
    }

    protected void notifyListenersGainChangeEvent() {
        GainChangeEvent event = new GainChangeEvent(this, this.getMute(), this.getDB(), this.getLevel());
        this.notifyListenersGainChangeEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersGainChangeEvent(GainChangeEvent event) {
        ArrayList<GainChangeListener> listenersCopy = new ArrayList<GainChangeListener>();
        List<GainChangeListener> list = this.listeners;
        synchronized (list) {
            listenersCopy.addAll(this.listeners);
        }
        for (int i = 0; i < listenersCopy.size(); ++i) {
            GainChangeListener listener = (GainChangeListener)listenersCopy.get(i);
            listener.gainChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGainChangeListener(GainChangeListener listener) {
        List<GainChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public float setDB(float gain) {
        this.setLevel(AbstractGainControl.dBToLevel(gain));
        float result = this.getDB();
        this.notifyListenersGainChangeEvent();
        return result;
    }

    @Override
    public void setMute(boolean mute) {
        if (mute == this.mute) {
            return;
        }
        if (mute) {
            this.savedLevelDuringMute = this.getLevel();
            this.setLevel(0.0f);
            this.mute = true;
        } else {
            this.setLevel(this.savedLevelDuringMute);
            this.mute = false;
        }
        this.notifyListenersGainChangeEvent();
    }
}

