/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.video;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.ImageInputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Owned;
import javax.media.control.FrameRateControl;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.media.AbstractVideoRenderer;
import net.sf.fmj.media.codec.video.jpeg.RFC2035;
import net.sf.fmj.media.renderer.video.JVideoComponent;
import net.sf.fmj.utility.ArrayUtility;
import net.sf.fmj.utility.LoggerSingleton;

public class JPEGRTPRenderer
extends AbstractVideoRenderer
implements VideoRenderer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean TRACE = true;
    private final Format[] supportedInputFormats = new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)};
    private JVideoComponent component = new JVideoComponent();
    private JPEGRTPFrame currentFrame;
    private ImageReader decoder;
    private JPEGImageReadParam param;
    private JPEGHuffmanTable[] huffmanDCTables;
    private JPEGHuffmanTable[] huffmanACTables;
    private JPEGQTable[] qtable;
    private int quality = -1;
    private float frameRate = -1.0f;
    private int framesProcessed;
    private long lastTimestamp;
    private BufferedImage itsImage;

    public JPEGRTPRenderer() {
        this.addControl(this);
        this.addControl(new VideoFrameRateControl());
    }

    @Override
    public void close() {
        if (null != this.decoder) {
            this.decoder.dispose();
        }
    }

    private JPEGHuffmanTable[] createACHuffmanTables() {
        JPEGHuffmanTable acChm = new JPEGHuffmanTable(RFC2035.chm_ac_codelens, RFC2035.chm_ac_symbols);
        JPEGHuffmanTable acLum = new JPEGHuffmanTable(RFC2035.lum_ac_codelens, RFC2035.lum_ac_symbols);
        JPEGHuffmanTable[] result = new JPEGHuffmanTable[]{acLum, acChm};
        return result;
    }

    private JPEGHuffmanTable[] createDCHuffmanTables() {
        JPEGHuffmanTable dcChm = new JPEGHuffmanTable(RFC2035.chm_dc_codelens, RFC2035.chm_dc_symbols);
        JPEGHuffmanTable dcLum = new JPEGHuffmanTable(RFC2035.lum_dc_codelens, RFC2035.lum_dc_symbols);
        JPEGHuffmanTable[] result = new JPEGHuffmanTable[]{dcLum, dcChm};
        return result;
    }

    private JPEGQTable[] createQTable(int q) {
        byte[] lumQ = new byte[64];
        byte[] chmQ = new byte[64];
        RFC2035.MakeTables(q, lumQ, chmQ, RFC2035.jpeg_luma_quantizer_normal, RFC2035.jpeg_chroma_quantizer_normal);
        JPEGQTable qtable_luma = new JPEGQTable(ArrayUtility.byteArrayToIntArray(lumQ));
        JPEGQTable qtable_chroma = new JPEGQTable(ArrayUtility.byteArrayToIntArray(chmQ));
        JPEGQTable[] result = new JPEGQTable[]{qtable_luma, qtable_chroma};
        return result;
    }

    @Override
    public int doProcess(Buffer buffer) {
        long timestamp = buffer.getTimeStamp();
        if (null == this.currentFrame) {
            this.currentFrame = new JPEGRTPFrame(timestamp);
        }
        if (timestamp < this.currentFrame.timestamp) {
            logger.fine("JPEGRTPRenderer: dropping packet ts=" + timestamp);
        } else if (timestamp > this.currentFrame.timestamp) {
            logger.fine("JPEGRTPRenderer: dropping current frame ts=" + this.currentFrame.timestamp + ", got new packet ts=" + timestamp);
            this.currentFrame.clear(timestamp);
            this.currentFrame.add(buffer);
        } else {
            this.currentFrame.add(buffer);
        }
        if (this.currentFrame.isComplete()) {
            byte[] data = this.currentFrame.getData();
            this.currentFrame = null;
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                ImageInputStream stream = ImageIO.createImageInputStream(in);
                this.decoder.setInput(stream, false, false);
                this.param.setDestination(this.itsImage);
                this.decoder.read(0, this.param);
                this.component.setImage(this.itsImage);
                stream.close();
                in.close();
                long currentTimestamp = System.nanoTime();
                if (-1L == this.lastTimestamp) {
                    this.lastTimestamp = currentTimestamp;
                }
                ++this.framesProcessed;
                if (currentTimestamp - this.lastTimestamp > 1000000000L) {
                    float diffTime = (float)(currentTimestamp - this.lastTimestamp) / 1000000.0f;
                    this.frameRate = (float)this.framesProcessed * (1000.0f / diffTime);
                    this.framesProcessed = 0;
                    this.lastTimestamp = currentTimestamp;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    private void dump(byte[] data, int length) {
        int index = 0;
        while (index < length) {
            String aString = "";
            for (int i = 0; i < 16; ++i) {
                String s = Integer.toHexString(data[index++] & 0xFF);
                aString = aString + (s.length() < 2 ? "0" + s : s);
                aString = aString + " ";
                if (index >= length) break;
            }
            System.out.println(aString);
        }
        System.out.println(" ");
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public String getName() {
        return "JPEG/RTP Renderer";
    }

    @Override
    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    private void initDecoder(int q) {
        if (null != this.decoder) {
            this.decoder.dispose();
        }
        this.decoder = ImageIO.getImageReadersByFormatName("JPEG").next();
        this.param = new JPEGImageReadParam();
        this.huffmanACTables = this.createACHuffmanTables();
        this.huffmanDCTables = this.createDCHuffmanTables();
        this.qtable = this.createQTable(q);
        this.param.setDecodeTables(this.qtable, this.huffmanDCTables, this.huffmanACTables);
    }

    @Override
    public Format setInputFormat(Format format) {
        VideoFormat chosenFormat = (VideoFormat)super.setInputFormat(format);
        if (chosenFormat != null) {
            this.getComponent().setPreferredSize(chosenFormat.getSize());
        }
        return chosenFormat;
    }

    private class VideoFrameRateControl
    implements FrameRateControl,
    Owned {
        private VideoFrameRateControl() {
        }

        @Override
        public Component getControlComponent() {
            return null;
        }

        @Override
        public float getFrameRate() {
            return JPEGRTPRenderer.this.frameRate;
        }

        @Override
        public float getMaxSupportedFrameRate() {
            return -1.0f;
        }

        @Override
        public Object getOwner() {
            return JPEGRTPRenderer.this;
        }

        @Override
        public float getPreferredFrameRate() {
            return -1.0f;
        }

        @Override
        public float setFrameRate(float newFrameRate) {
            return -1.0f;
        }
    }

    private class JPEGRTPFrame {
        public JPEGRTPFrame firstItem;
        public long timestamp;
        public boolean hasRTPMarker;
        public int count;
        public int dataLength;
        public JPEGRTPFrame nextItem;
        public Buffer itemData;
        public long fragmentOffset;
        byte[] jpegHeader = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 2, 0, 0, 1, 0, 1, 0, 0, -1, -64, 0, 17, 8, 0, -112, 0, -80, 3, 1, 34, 0, 2, 17, 1, 3, 17, 1, -1, -38, 0, 12, 3, 1, 0, 2, 17, 3, 17, 0, 63, 0};

        public JPEGRTPFrame(Buffer buffer) {
            this.itemData = buffer;
        }

        public JPEGRTPFrame(long timestamp) {
            this.timestamp = timestamp;
        }

        public void add(Buffer buffer) {
            JPEGRTPFrame aNewItem = new JPEGRTPFrame((Buffer)buffer.clone());
            if ((buffer.getFlags() & 0x800) > 0) {
                this.hasRTPMarker = true;
            }
            ++this.count;
            if (null == this.firstItem) {
                this.firstItem = aNewItem;
            } else {
                JPEGRTPFrame aItem = this.firstItem;
                while (aItem.nextItem != null) {
                    aItem = aItem.nextItem;
                }
                aItem.nextItem = aNewItem;
            }
            byte[] data = (byte[])buffer.getData();
            aNewItem.fragmentOffset = 0L;
            for (int i = 0; i < 3; ++i) {
                aNewItem.fragmentOffset <<= 8;
                aNewItem.fragmentOffset += (long)(data[i + 13] & 0xFF);
            }
        }

        public void clear(long timestamp) {
            this.firstItem = null;
            this.timestamp = timestamp;
            this.hasRTPMarker = false;
            this.count = 0;
            this.dataLength = 0;
        }

        public byte[] getData() {
            byte[] frame = new byte[this.jpegHeader.length + this.dataLength + 2];
            System.arraycopy(this.jpegHeader, 0, frame, 0, this.jpegHeader.length);
            JPEGRTPFrame aItem = this.firstItem;
            long expectedFragmentOffset = 0L;
            int offset = this.jpegHeader.length;
            while (aItem != null) {
                aItem = this.firstItem;
                while (aItem != null && aItem.fragmentOffset != expectedFragmentOffset) {
                    aItem = aItem.nextItem;
                }
                if (null == aItem) continue;
                int len = aItem.itemData.getLength() - 8;
                byte[] data = (byte[])aItem.itemData.getData();
                System.arraycopy(data, aItem.itemData.getOffset() + 8, frame, offset, len);
                offset += len;
                expectedFragmentOffset += (long)len;
            }
            byte[] packetData = (byte[])this.firstItem.itemData.getData();
            int width = packetData[this.firstItem.itemData.getOffset() + 6] << 3;
            int height = packetData[this.firstItem.itemData.getOffset() + 7] << 3;
            frame[25] = (byte)(height >> 8 & 0xFF);
            frame[26] = (byte)(height & 0xFF);
            frame[27] = (byte)(width >> 8 & 0xFF);
            frame[28] = (byte)(width & 0xFF);
            frame[frame.length - 2] = -1;
            frame[frame.length - 1] = -39;
            byte q = packetData[this.firstItem.itemData.getOffset() + 5];
            if (null == JPEGRTPRenderer.this.decoder) {
                JPEGRTPRenderer.this.initDecoder(q);
            }
            if (JPEGRTPRenderer.this.quality != -1 && q != JPEGRTPRenderer.this.quality) {
                JPEGRTPRenderer.this.initDecoder(q);
            }
            JPEGRTPRenderer.this.quality = q;
            if (null == JPEGRTPRenderer.this.itsImage) {
                JPEGRTPRenderer.this.itsImage = new BufferedImage(width, height, 1);
            }
            return frame;
        }

        public boolean isComplete() {
            if (this.hasRTPMarker) {
                JPEGRTPFrame aItem = this.firstItem;
                long expectedFragmentOffset = 0L;
                this.dataLength = 0;
                while (aItem != null) {
                    aItem = this.firstItem;
                    while (aItem != null && aItem.fragmentOffset != expectedFragmentOffset) {
                        aItem = aItem.nextItem;
                    }
                    if (null == aItem) continue;
                    int len = aItem.itemData.getLength() - 8;
                    this.dataLength += len;
                    if ((aItem.itemData.getFlags() & 0x800) > 0) {
                        return true;
                    }
                    expectedFragmentOffset += (long)len;
                }
            }
            return false;
        }
    }
}

