/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import net.java.sip.communicator.impl.neomedia.AudioConfigurationPanel;
import net.java.sip.communicator.impl.neomedia.AudioDeviceConfigurationListener;
import net.java.sip.communicator.impl.neomedia.CallRecordingConfigForm;
import net.java.sip.communicator.impl.neomedia.MediaConfigurationImpl;
import net.java.sip.communicator.impl.neomedia.SecurityConfigForm;
import net.java.sip.communicator.impl.neomedia.VideoConfigurationPanel;
import net.java.sip.communicator.impl.neomedia.codec.video.h264.ConfigurationPanel;
import net.java.sip.communicator.impl.neomedia.codec.video.h264.OpenH264Retriever;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaConfigurationService;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NeomediaActivator
implements BundleActivator {
    private static final String AUDIO_CONFIG_DISABLED_PROP = "net.java.sip.communicator.impl.neomedia.AUDIO_CONFIG_DISABLED";
    private static ConfigurationForm audioConfigurationForm;
    private static AudioNotifierService audioNotifierService;
    private static BundleContext bundleContext;
    private static final String CALL_RECORDING_CONFIG_DISABLED_PROP = "net.java.sip.communicator.impl.neomedia.callrecordingconfig.DISABLED";
    private static ConfigurationService configurationService;
    public static final String DEVICE_CONFIGURATION_HAS_CHANGED = "DeviceConfigurationChanged";
    private static FileAccessService fileAccessService;
    private static final String H264_CONFIG_DISABLED_PROP = "net.java.sip.communicator.impl.neomedia.h264config.DISABLED";
    private static MediaConfigurationImpl mediaConfiguration;
    private static MediaServiceImpl mediaServiceImpl;
    public static final String NEW_SELECTED_DEVICE = "NewSelectedDevice";
    private static NotificationService notificationService;
    private static PacketLoggingService packetLoggingService;
    private static ResourceManagementService resources;
    private static final String VIDEO_CONFIG_DISABLED_PROP = "net.java.sip.communicator.impl.neomedia.VIDEO_CONFIG_DISABLED";
    private static ConfigurationForm videoConfigurationForm;
    private static final String ZRTP_CONFIG_DISABLED_PROP = "net.java.sip.communicator.impl.neomedia.zrtpconfig.DISABLED";
    private AudioDeviceConfigurationListener audioDeviceConfigurationPropertyChangeListener;
    private final Logger logger = Logger.getLogger(NeomediaActivator.class);

    public static ConfigurationForm getAudioConfigurationForm() {
        return audioConfigurationForm;
    }

    public static AudioNotifierService getAudioNotifierService() {
        if (audioNotifierService == null) {
            audioNotifierService = (AudioNotifierService)ServiceUtils.getService((BundleContext)bundleContext, AudioNotifierService.class);
        }
        return audioNotifierService;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configurationService;
    }

    public static FileAccessService getFileAccessService() {
        if (fileAccessService == null) {
            fileAccessService = (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
        }
        return fileAccessService;
    }

    public static MediaConfigurationService getMediaConfiguration() {
        return mediaConfiguration;
    }

    public static MediaServiceImpl getMediaServiceImpl() {
        return mediaServiceImpl;
    }

    public static NotificationService getNotificationService() {
        ServiceReference notifReference;
        if (notificationService == null && (notificationService = (NotificationService)bundleContext.getService(notifReference = bundleContext.getServiceReference(NotificationService.class.getName()))) != null) {
            notificationService.registerDefaultNotificationForEvent(DEVICE_CONFIGURATION_HAS_CHANGED, "PopupMessageAction", "Device configuration has changed", null);
            notificationService.registerDefaultNotificationForEvent(NEW_SELECTED_DEVICE, "PopupMessageAction", "New selected device", null);
        }
        return notificationService;
    }

    public static PacketLoggingService getPacketLogging() {
        if (packetLoggingService == null) {
            packetLoggingService = (PacketLoggingService)ServiceUtils.getService((BundleContext)bundleContext, PacketLoggingService.class);
        }
        return packetLoggingService;
    }

    public static ResourceManagementService getResources() {
        if (resources == null) {
            resources = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resources;
    }

    public static ConfigurationForm getVideoConfigurationForm() {
        return videoConfigurationForm;
    }

    public void start(BundleContext bundleContext) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Started.");
        }
        NeomediaActivator.bundleContext = bundleContext;
        mediaServiceImpl = (MediaServiceImpl)LibJitsi.getMediaService();
        bundleContext.registerService(MediaService.class.getName(), (Object)mediaServiceImpl, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Media Service ... [REGISTERED]");
        }
        mediaConfiguration = new MediaConfigurationImpl();
        bundleContext.registerService(MediaConfigurationService.class.getName(), (Object)NeomediaActivator.getMediaConfiguration(), null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Media Configuration ... [REGISTERED]");
        }
        ConfigurationService cfg = NeomediaActivator.getConfigurationService();
        Hashtable<String, String> mediaProps = new Hashtable<String, String>();
        ((Dictionary)mediaProps).put("FORM_TYPE", "GENERAL_TYPE");
        if (cfg == null || !cfg.getBoolean(AUDIO_CONFIG_DISABLED_PROP, false)) {
            audioConfigurationForm = new LazyConfigurationForm(AudioConfigurationPanel.class.getName(), this.getClass().getClassLoader(), "plugin.mediaconfig.AUDIO_ICON", "impl.neomedia.configform.AUDIO", 3);
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)audioConfigurationForm, mediaProps);
            if (this.audioDeviceConfigurationPropertyChangeListener == null) {
                NeomediaActivator.getNotificationService();
                this.audioDeviceConfigurationPropertyChangeListener = new AudioDeviceConfigurationListener(audioConfigurationForm);
                mediaServiceImpl.getDeviceConfiguration().addPropertyChangeListener((PropertyChangeListener)this.audioDeviceConfigurationPropertyChangeListener);
            }
        }
        if (cfg == null || !cfg.getBoolean(VIDEO_CONFIG_DISABLED_PROP, false)) {
            videoConfigurationForm = new LazyConfigurationForm(VideoConfigurationPanel.class.getName(), this.getClass().getClassLoader(), "plugin.mediaconfig.VIDEO_ICON", "impl.neomedia.configform.VIDEO", 4);
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)videoConfigurationForm, mediaProps);
        }
        if (cfg == null || !cfg.getBoolean(H264_CONFIG_DISABLED_PROP, false)) {
            Hashtable<String, String> h264Props = new Hashtable<String, String>();
            ((Dictionary)h264Props).put("FORM_TYPE", "ADVANCED_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(ConfigurationPanel.class.getName(), this.getClass().getClassLoader(), "plugin.mediaconfig.VIDEO_ICON", "impl.neomedia.configform.H264", -1, true), h264Props);
        }
        if (cfg == null || !cfg.getBoolean(ZRTP_CONFIG_DISABLED_PROP, false)) {
            Hashtable<String, String> securityProps = new Hashtable<String, String>();
            ((Dictionary)securityProps).put("FORM_TYPE", "SECURITY_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(SecurityConfigForm.class.getName(), this.getClass().getClassLoader(), "impl.media.security.zrtp.CONF_ICON", "impl.media.security.zrtp.TITLE", 0), securityProps);
        }
        System.setProperty("gov.nist.core.STRIP_ADDR_SCOPES", "true");
        AudioNotifierService audioNotifierService = LibJitsi.getAudioNotifierService();
        audioNotifierService.setMute(cfg == null || !cfg.getBoolean("net.java.sip.communicator.impl.sound.isSoundEnabled", true));
        bundleContext.registerService(AudioNotifierService.class.getName(), (Object)audioNotifierService, null);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Audio Notifier Service ...[REGISTERED]");
        }
        if (cfg == null || !cfg.getBoolean(CALL_RECORDING_CONFIG_DISABLED_PROP, false) && !cfg.getBoolean("net.java.sip.communicator.impl.gui.main.call.HIDE_CALL_RECORD_BUTTON", false)) {
            Hashtable<String, String> callRecordingProps = new Hashtable<String, String>();
            ((Dictionary)callRecordingProps).put("FORM_TYPE", "ADVANCED_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(CallRecordingConfigForm.class.getName(), this.getClass().getClassLoader(), null, "plugin.callrecordingconfig.CALL_RECORDING_CONFIG", 1100, true), callRecordingProps);
        }
        OpenH264Retriever.checkForUpdateAndDownload();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.audioDeviceConfigurationPropertyChangeListener != null) {
                mediaServiceImpl.getDeviceConfiguration().removePropertyChangeListener((PropertyChangeListener)this.audioDeviceConfigurationPropertyChangeListener);
                this.audioDeviceConfigurationPropertyChangeListener.dispose();
                this.audioDeviceConfigurationPropertyChangeListener = null;
            }
        }
        finally {
            configurationService = null;
            fileAccessService = null;
            mediaServiceImpl = null;
            resources = null;
        }
    }

    static {
        packetLoggingService = null;
    }
}

