/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.dsi;

import java.util.LinkedList;
import java.util.List;
import org.jitsi.utils.dsi.ActiveSpeakerChangedListener;
import org.jitsi.utils.dsi.ActiveSpeakerDetector;

public abstract class AbstractActiveSpeakerDetector
implements ActiveSpeakerDetector {
    private static final ActiveSpeakerChangedListener[] NO_LISTENERS = new ActiveSpeakerChangedListener[0];
    private final List<ActiveSpeakerChangedListener> listeners = new LinkedList<ActiveSpeakerChangedListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActiveSpeakerChangedListener(ActiveSpeakerChangedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<ActiveSpeakerChangedListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    protected void fireActiveSpeakerChanged(long ssrc) {
        ActiveSpeakerChangedListener[] listeners;
        for (ActiveSpeakerChangedListener listener : listeners = this.getActiveSpeakerChangedListeners()) {
            listener.activeSpeakerChanged(ssrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActiveSpeakerChangedListener[] getActiveSpeakerChangedListeners() {
        List<ActiveSpeakerChangedListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.size() == 0 ? NO_LISTENERS : this.listeners.toArray(NO_LISTENERS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveSpeakerChangedListener(ActiveSpeakerChangedListener listener) {
        if (listener != null) {
            List<ActiveSpeakerChangedListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

