/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat2;

import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class Chat
extends Manager {
    private final EntityBareJid jid;
    volatile EntityFullJid lockedResource;
    Presence lastPresenceOfLockedResource;

    Chat(XMPPConnection connection, EntityBareJid jid) {
        super(connection);
        this.jid = jid;
    }

    public void send(CharSequence message) throws SmackException.NotConnectedException, InterruptedException {
        Message stanza = new Message();
        stanza.setBody(message);
        this.send(stanza);
    }

    public void send(Message message) throws SmackException.NotConnectedException, InterruptedException {
        switch (message.getType()) {
            case normal: 
            case chat: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Message must be of type 'normal' or 'chat'");
            }
        }
        EntityFullJid to = this.lockedResource;
        if (to == null) {
            to = this.jid;
        }
        message.setTo((Jid)to);
        this.connection().sendStanza((Stanza)message);
    }

    public EntityBareJid getXmppAddressOfChatPartner() {
        return this.jid;
    }

    void unlockResource() {
        this.lockedResource = null;
        this.lastPresenceOfLockedResource = null;
    }
}

