/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pep;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.jidtype.AbstractJidTypeFilter;
import org.jivesoftware.smack.filter.jidtype.FromJidTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.pep.PEPListener;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubFeature;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.filter.EventExtensionFilter;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public final class PEPManager
extends Manager {
    private static final Map<XMPPConnection, PEPManager> INSTANCES = new WeakHashMap<XMPPConnection, PEPManager>();
    private static final StanzaFilter FROM_BARE_JID_WITH_EVENT_EXTENSION_FILTER = new AndFilter(new StanzaFilter[]{new FromJidTypeFilter(AbstractJidTypeFilter.JidType.BareJid), EventExtensionFilter.INSTANCE});
    private final Set<PEPListener> pepListeners = new CopyOnWriteArraySet<PEPListener>();
    private static final PubSubFeature[] REQUIRED_FEATURES = new PubSubFeature[]{PubSubFeature.auto_create, PubSubFeature.auto_subscribe, PubSubFeature.filtered_notifications};

    public static synchronized PEPManager getInstanceFor(XMPPConnection connection) {
        PEPManager pepManager = INSTANCES.get(connection);
        if (pepManager == null) {
            pepManager = new PEPManager(connection);
            INSTANCES.put(connection, pepManager);
        }
        return pepManager;
    }

    private PEPManager(XMPPConnection connection) {
        super(connection);
        StanzaListener packetListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Message message = (Message)stanza;
                EventElement event = EventElement.from(stanza);
                assert (event != null);
                EntityBareJid from = message.getFrom().asEntityBareJidIfPossible();
                assert (from != null);
                for (PEPListener listener : PEPManager.this.pepListeners) {
                    listener.eventReceived(from, event, message);
                }
            }
        };
        connection.addSyncStanzaListener(packetListener, FROM_BARE_JID_WITH_EVENT_EXTENSION_FILTER);
    }

    public boolean addPEPListener(PEPListener pepListener) {
        return this.pepListeners.add(pepListener);
    }

    public boolean removePEPListener(PEPListener pepListener) {
        return this.pepListeners.remove(pepListener);
    }

    public void publish(Item item, String node) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, PubSubException.NotAPubSubNodeException {
        XMPPConnection connection = this.connection();
        PubSubManager pubSubManager = PubSubManager.getInstance(connection, (BareJid)connection.getUser().asEntityBareJid());
        LeafNode pubSubNode = (LeafNode)pubSubManager.getNode(node);
        pubSubNode.publish(item);
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        BareJid localBareJid = connection.getUser().asBareJid();
        return serviceDiscoveryManager.supportsFeatures((Jid)localBareJid, REQUIRED_FEATURES);
    }
}

