/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.util.XmppDateTime;

public class Time
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:time";
    public static final String ELEMENT = "time";
    private static final Logger LOGGER = Logger.getLogger(Time.class.getName());
    private String utc;
    private String tzo;

    public Time() {
        super(ELEMENT, NAMESPACE);
        this.setType(IQ.Type.get);
    }

    public Time(Calendar cal) {
        super(ELEMENT, NAMESPACE);
        this.tzo = XmppDateTime.asString((TimeZone)cal.getTimeZone());
        this.utc = XmppDateTime.formatXEP0082Date((Date)cal.getTime());
    }

    public Date getTime() {
        if (this.utc == null) {
            return null;
        }
        Date date = null;
        try {
            date = XmppDateTime.parseDate((String)this.utc);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error getting local time", e);
        }
        return date;
    }

    public void setTime(Date time) {
    }

    public String getUtc() {
        return this.utc;
    }

    public void setUtc(String utc) {
        this.utc = utc;
    }

    public String getTzo() {
        return this.tzo;
    }

    public void setTzo(String tzo) {
        this.tzo = tzo;
    }

    public static Time createResponse(IQ request) {
        Time time = new Time(Calendar.getInstance());
        time.setType(IQ.Type.result);
        time.setTo(request.getFrom());
        return time;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        if (this.utc != null) {
            buf.rightAngleBracket();
            buf.append((CharSequence)"<utc>").append((CharSequence)this.utc).append((CharSequence)"</utc>");
            buf.append((CharSequence)"<tzo>").append((CharSequence)this.tzo).append((CharSequence)"</tzo>");
        } else {
            buf.setEmptyElement();
        }
        return buf;
    }
}

