/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ComponentUtils;
import net.java.sip.communicator.util.GuiUtils;

public class ExtendedTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 0L;
    private HTMLEditorKit htmlKit = new HTMLEditorKit();
    private HTMLDocument htmlDoc = (HTMLDocument)this.htmlKit.createDefaultDocument();
    private static SwingDragGestureRecognizer recognizer = null;

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        int n = flavor.length;
        for (int i = 0; i < n; ++i) {
            JTextComponent c;
            if (flavor[i].equals(DataFlavor.javaFileListFlavor)) {
                return true;
            }
            if (!flavor[i].equals(DataFlavor.stringFlavor)) continue;
            return comp instanceof JTextComponent && (c = (JTextComponent)comp).isEditable() && c.isEnabled();
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        if (component instanceof JTextPane || component instanceof JTextField) {
            return new SelectedTextTransferable((JTextComponent)component);
        }
        return super.createTransferable(component);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clipboard, int action) throws IllegalStateException {
        if (comp instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)comp;
            int startIndex = textComponent.getSelectionStart();
            int endIndex = textComponent.getSelectionEnd();
            try {
                Document doc = textComponent.getDocument();
                String srcData = this.getSelectedTextFromComponent(textComponent);
                if (srcData != null) {
                    StringSelection contents = new StringSelection(srcData);
                    clipboard.setContents(contents, null);
                    if (action == 2) {
                        doc.remove(startIndex, endIndex - startIndex);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public String getSelectedTextFromComponent(JTextComponent textComponent) {
        int endIndex;
        String srcData = null;
        int startIndex = textComponent.getSelectionStart();
        if (startIndex != (endIndex = textComponent.getSelectionEnd())) {
            Document doc = textComponent.getDocument();
            int selectionLength = endIndex - startIndex;
            try {
                if (textComponent instanceof JTextPane) {
                    JTextPane textPaneComponent = (JTextPane)textComponent;
                    StringWriter stringWriter = new StringWriter();
                    textPaneComponent.getEditorKit().write(stringWriter, doc, startIndex, selectionLength);
                    String data = stringWriter.toString();
                    String smileyHtmlPattern = "<\\s*[iI][mM][gG](.*?)[aA][lL][tT]\\s*=\\s*[\\\"']([^\\\"]*)[\\\"'](.*?)>";
                    Pattern p = Pattern.compile(smileyHtmlPattern, 32);
                    Matcher m = p.matcher(data);
                    boolean hasImg = m.find();
                    Pattern pMsgHeader = Pattern.compile("<\\s*h\\d.*?id=['\"]messageHeader['\"]", 34);
                    Matcher mMsgHeader = pMsgHeader.matcher(data);
                    boolean hasMsgHeader = mMsgHeader.find();
                    if (hasImg || hasMsgHeader) {
                        String tempData = "";
                        if (hasImg) {
                            int start = 0;
                            do {
                                tempData = tempData + data.substring(start, m.start()) + GuiUtils.escapeHTMLChars((String)m.group(2));
                                start = m.end();
                            } while (m.find());
                            tempData = tempData + data.substring(start);
                        } else {
                            tempData = data;
                        }
                        tempData = tempData.replaceAll("<[/]*PLAINTEXT>.*<[/]*PLAINTEXT>", "");
                        tempData = tempData.replaceAll("<\\s*[bB][rR][^>]*>", "<a></a>");
                        if (hasMsgHeader) {
                            tempData = tempData.replaceAll("<[/]*\\s*([tT][aA][bB][lL][eE]|[tT][rR]|[tT][dD]|[hH]\\d)[^>]*?>", "");
                        }
                        this.htmlDoc.remove(0, this.htmlDoc.getLength());
                        this.htmlKit.read(new StringReader(tempData), (Document)this.htmlDoc, 0);
                        srcData = this.htmlDoc.getText(0, this.htmlDoc.getLength());
                    }
                }
                if (srcData == null) {
                    srcData = doc.getText(startIndex, selectionLength);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return srcData;
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        ImageIcon icon = null;
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String text = null;
            try {
                text = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (text != null) {
                Rectangle2D bounds = ComponentUtils.getDefaultStringSize(text);
                BufferedImage image = new BufferedImage((int)Math.ceil(bounds.getWidth()), (int)Math.ceil(bounds.getHeight()), 2);
                Graphics g = image.getGraphics();
                AntialiasingManager.activateAntialiasing(g);
                g.setColor(Color.BLACK);
                g.drawString(text, 0, 10);
                icon = new ImageIcon(image);
            }
        }
        return icon;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        int srcActions = this.getSourceActions(comp);
        int dragAction = srcActions & action;
        if (!(e instanceof MouseEvent)) {
            action = 0;
        }
        if (action != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new SwingDragGestureRecognizer(new DragHandler());
            }
            recognizer.gestured(comp, (MouseEvent)e, srcActions, dragAction);
        } else {
            this.exportDone(comp, null, 0);
        }
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private DragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            ExtendedTransferHandler th = (ExtendedTransferHandler)c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    Image img = null;
                    Icon icn = th.getVisualRepresentation(t);
                    if (icn != null) {
                        if (icn instanceof ImageIcon) {
                            img = ((ImageIcon)icn).getImage();
                        } else {
                            img = new BufferedImage(icn.getIconWidth(), icn.getIconHeight(), 6);
                            Graphics g = img.getGraphics();
                            icn.paintIcon(c, g, 0, 0);
                        }
                    }
                    if (img == null) {
                        dge.startDrag(null, t, this);
                    } else {
                        dge.startDrag(null, img, new Point(0, -1 * img.getHeight(null)), t, this);
                    }
                    return;
                }
                catch (RuntimeException re) {
                    c.setAutoscrolls(this.scrolls);
                }
            }
            th.exportDone(c, t, 0);
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            DragSourceContext dsc = e.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            if (e.getDropSuccess()) {
                ((ExtendedTransferHandler)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), e.getDropAction());
            } else {
                ((ExtendedTransferHandler)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), 0);
            }
            c.setAutoscrolls(this.scrolls);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        private static final long serialVersionUID = 0L;

        SwingDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }

    public class SelectedTextTransferable
    implements Transferable {
        private JTextComponent textComponent;

        public SelectedTextTransferable(JTextComponent component) {
            this.textComponent = component;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.stringFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.stringFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            String data = ExtendedTransferHandler.this.getSelectedTextFromComponent(this.textComponent);
            return data == null ? "" : data;
        }
    }
}

