/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;

public class MasterPasswordInputDialog
extends SIPCommDialog
implements ActionListener,
KeyListener {
    private static final Logger logger = Logger.getLogger(MasterPasswordInputDialog.class);
    private static final long serialVersionUID = 0L;
    private static MasterPasswordInputDialog dialog;
    private final ResourceManagementService resources = DesktopUtilActivator.getResources();
    private String password;
    private JPasswordField currentPasswdField;
    private JButton okButton;
    private JButton cancelButton;
    private JTextArea infoTextArea;
    private JTextArea errorTextArea;
    private JPanel buttonsPanel;
    private JPanel dataPanel;

    private MasterPasswordInputDialog() {
        super(false);
        this.initComponents();
        this.setTitle(this.resources.getI18NString("plugin.securityconfig.masterpassword.MP_TITLE"));
        this.setModal(true);
        this.setResizable(false);
        TransparentPanel mainPanel = new TransparentPanel(new BorderLayout(10, 10));
        ((JComponent)((Object)mainPanel)).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ((Container)((Object)mainPanel)).add(MasterPasswordInputDialog.createIconComponent(), "West");
        ((Container)((Object)mainPanel)).add(this.dataPanel);
        this.getContentPane().add((Component)((Object)mainPanel));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    private void initComponents() {
        this.dataPanel = new TransparentPanel();
        this.dataPanel.setLayout(new BoxLayout(this.dataPanel, 1));
        this.infoTextArea = new JTextArea();
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setFocusable(false);
        this.infoTextArea.setOpaque(false);
        this.infoTextArea.setFont(this.infoTextArea.getFont().deriveFont(1));
        this.infoTextArea.setText(this.resources.getI18NString("plugin.securityconfig.masterpassword.MP_INPUT"));
        this.errorTextArea = new JTextArea();
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setFocusable(false);
        this.errorTextArea.setOpaque(false);
        this.errorTextArea.setForeground(Color.red);
        this.errorTextArea.setFont(this.errorTextArea.getFont().deriveFont(1));
        this.errorTextArea.setText(this.resources.getI18NString("plugin.securityconfig.masterpassword.MP_VERIFICATION_FAILURE_MSG"));
        this.currentPasswdField = new JPasswordField(15);
        this.currentPasswdField.addKeyListener(this);
        this.currentPasswdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MasterPasswordInputDialog.this.okButton.doClick();
            }
        });
        this.currentPasswdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt2) {
                int caretPosition = MasterPasswordInputDialog.this.currentPasswdField.getCaretPosition();
                MasterPasswordInputDialog.this.currentPasswdField.setSelectionEnd(0);
                MasterPasswordInputDialog.this.currentPasswdField.setCaretPosition(caretPosition);
            }
        });
        this.okButton = new JButton(this.resources.getI18NString("service.gui.OK"));
        this.okButton.setMnemonic(this.resources.getI18nMnemonic("service.gui.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.resources.getI18NString("service.gui.CANCEL"));
        this.cancelButton.setMnemonic(this.resources.getI18nMnemonic("service.gui.CANCEL"));
        this.cancelButton.addActionListener(this);
        this.buttonsPanel = new TransparentPanel(new FlowLayout(2, 0, 5));
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.rebuildMainPanel(false);
    }

    private void rebuildMainPanel(boolean includeErrorMsg) {
        this.dataPanel.removeAll();
        if (includeErrorMsg) {
            this.dataPanel.add(this.errorTextArea);
        }
        this.dataPanel.add(this.infoTextArea);
        this.dataPanel.add(this.currentPasswdField);
        this.dataPanel.add(this.buttonsPanel);
    }

    public static String showInput(final boolean prevSuccess) {
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MasterPasswordInputDialog.showInput(prevSuccess);
                    }
                });
            } else {
                if (dialog == null) {
                    dialog = new MasterPasswordInputDialog();
                }
                dialog.rebuildMainPanel(!prevSuccess);
                dialog.resetPassword();
                dialog.setVisible(true);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error showing dialog", t);
        }
        return MasterPasswordInputDialog.dialog.password;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton sourceButton = (JButton)e.getSource();
        if (sourceButton.equals(this.okButton)) {
            this.password = new String(this.currentPasswdField.getPassword());
        }
        dialog.dispose();
    }

    @Override
    protected void close(boolean escaped) {
        this.cancelButton.doClick();
    }

    private void resetPassword() {
        this.password = null;
        this.currentPasswdField.setText("");
        this.currentPasswdField.requestFocusInWindow();
        this.okButton.setEnabled(false);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        JPasswordField source = (JPasswordField)event.getSource();
        if (this.currentPasswdField.equals(source)) {
            String password = new String(this.currentPasswdField.getPassword());
            this.okButton.setEnabled(password.length() > 0);
            Object var3_3 = null;
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    private static Component createIconComponent() {
        TransparentPanel wrapIconPanel = new TransparentPanel(new BorderLayout());
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(DesktopUtilActivator.getResources().getImage("service.gui.icons.AUTHORIZATION_ICON"));
        ((Container)((Object)wrapIconPanel)).add(iconLabel, "North");
        return wrapIconPanel;
    }
}

