/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.LightGrayFilter;
import net.java.sip.communicator.plugin.desktoputil.OrderedComponent;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;

public class SIPCommButton
extends JButton
implements OrderedComponent {
    private static final long serialVersionUID = 0L;
    private Image bgImage;
    private Image pressedBgImage;
    private Image rolloverBgImage;
    private Image rolloverIconImage;
    private Image pressedIconImage;
    private Image iconImage;
    private ExtendedTooltip extendedTooltip;
    private int index = -1;

    public SIPCommButton() {
        this((Image)null);
    }

    public SIPCommButton(Image bgImage, Image rolloverImage, Image pressedImage, Image iconImage, Image rolloverIconImage, Image pressedIconImage) {
        MouseRolloverHandler mouseHandler = new MouseRolloverHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setContentAreaFilled(false);
        this.setBorder(null);
        this.bgImage = bgImage;
        this.rolloverBgImage = rolloverImage;
        this.pressedBgImage = pressedImage;
        this.rolloverIconImage = rolloverIconImage;
        this.pressedIconImage = pressedIconImage;
        this.iconImage = iconImage;
        if (bgImage != null) {
            this.setPreferredSize(new Dimension(bgImage.getWidth(null), bgImage.getHeight(null)));
            this.setIcon(new ImageIcon(this.bgImage));
        }
    }

    public SIPCommButton(Image bgImage, Image pressedImage, Image iconImage) {
        this(bgImage, null, pressedImage, iconImage, null, null);
    }

    public SIPCommButton(Image bgImage, Image iconImage) {
        this(bgImage, null, iconImage);
    }

    public SIPCommButton(Image bgImage) {
        this(bgImage, null);
    }

    public void setImage(Image bgImage) {
        this.bgImage = bgImage;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g = g.create();
        try {
            this.internalPaintComponent(g);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics g) {
        AntialiasingManager.activateAntialiasing(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Image paintBgImage = null;
        if (this.getModel().isPressed() && this.pressedBgImage != null) {
            paintBgImage = this.pressedBgImage;
        } else if (this.getModel().isRollover() && this.rolloverBgImage != null) {
            paintBgImage = this.rolloverBgImage;
        } else if (this.bgImage != null) {
            paintBgImage = this.iconImage == null && !this.isEnabled() ? new ImageIcon(LightGrayFilter.createDisabledImage(this.bgImage)).getImage() : this.bgImage;
        }
        if (paintBgImage != null) {
            g.drawImage(paintBgImage, this.getWidth() / 2 - paintBgImage.getWidth(null) / 2, this.getHeight() / 2 - paintBgImage.getHeight(null) / 2, this);
        }
        if (this.rolloverBgImage == null) {
            float visibility;
            FadeTracker fadeTracker = FadeTracker.getInstance();
            float f = visibility = this.getModel().isRollover() ? 1.0f : 0.0f;
            if (fadeTracker.isTracked((Component)this, FadeKind.ROLLOVER)) {
                visibility = fadeTracker.getFade((Component)this, FadeKind.ROLLOVER);
            }
            g.setColor(new Color(1.0f, 1.0f, 1.0f, visibility /= 2.0f));
            if (this.bgImage == null && (this.isContentAreaFilled() || visibility != 0.0f)) {
                g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 8, 8);
            }
        }
        Image paintIconImage = null;
        if (this.getModel().isPressed() && this.pressedIconImage != null) {
            paintIconImage = this.pressedIconImage;
        } else if (this.getModel().isRollover() && this.rolloverIconImage != null) {
            paintIconImage = this.rolloverIconImage;
        } else if (this.iconImage != null) {
            paintIconImage = !this.isEnabled() ? new ImageIcon(LightGrayFilter.createDisabledImage(this.iconImage)).getImage() : this.iconImage;
        }
        if (paintIconImage != null) {
            g.drawImage(paintIconImage, this.getWidth() / 2 - paintIconImage.getWidth(null) / 2, this.getHeight() / 2 - paintIconImage.getHeight(null) / 2, this);
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.repaint();
        return true;
    }

    public Image getBackgroundImage() {
        return this.bgImage;
    }

    public void setBackgroundImage(Image bgImage) {
        this.bgImage = bgImage;
        if (bgImage != null) {
            this.setPreferredSize(new Dimension(bgImage.getWidth(null), bgImage.getHeight(null)));
            this.setIcon(new ImageIcon(this.bgImage));
        }
    }

    public void setRolloverImage(Image rolloverImage) {
        this.rolloverBgImage = rolloverImage;
    }

    public void setPressedImage(Image pressedImage) {
        this.pressedBgImage = pressedImage;
    }

    public void setRolloverIcon(Image rolloverIconImage) {
        this.rolloverIconImage = rolloverIconImage;
    }

    public void setPressedIcon(Image pressedIconImage) {
        this.pressedIconImage = pressedIconImage;
    }

    public void setIconImage(Image iconImage) {
        this.iconImage = iconImage;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setTooltip(ExtendedTooltip extendedTooltip) {
        this.extendedTooltip = extendedTooltip;
    }

    public ExtendedTooltip getTooltip() {
        return this.extendedTooltip;
    }

    private class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseRolloverHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (SIPCommButton.this.isEnabled()) {
                SIPCommButton.this.getModel().setRollover(false);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeOut(FadeKind.ROLLOVER, (Component)SIPCommButton.this, true, (FadeTrackerCallback)new ButtonRepaintCallback());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SIPCommButton.this.isEnabled()) {
                SIPCommButton.this.getModel().setRollover(true);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeIn(FadeKind.ROLLOVER, (Component)SIPCommButton.this, true, (FadeTrackerCallback)new ButtonRepaintCallback());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private class ButtonRepaintCallback
    implements FadeTrackerCallback {
        private ButtonRepaintCallback() {
        }

        public void fadeEnded(FadeKind arg0) {
            this.repaintLater();
        }

        public void fadePerformed(FadeKind arg0, float arg1) {
            this.repaintLater();
        }

        private void repaintLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SIPCommButton.this.repaint();
                }
            });
        }

        public void fadeReversed(FadeKind arg0, boolean arg1, float arg2) {
        }
    }
}

