/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.SizeRequirements;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ParagraphView;

public class SIPCommHTMLEditorKit
extends HTMLEditorKit {
    private static final long serialVersionUID = 0L;
    private final JComponent container;

    public SIPCommHTMLEditorKit(JComponent container) {
        this.container = container;
    }

    @Override
    public ViewFactory getViewFactory() {
        return new HTMLFactoryX();
    }

    protected void viewCreated(ViewFactory factory, View view) {
    }

    static class ParagraphViewX
    extends ParagraphView {
        public ParagraphViewX(Element elem) {
            super(elem);
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements sizeRequirements) {
            if (sizeRequirements == null) {
                sizeRequirements = new SizeRequirements();
            }
            float pref = this.layoutPool.getPreferredSpan(axis);
            float min = this.layoutPool.getMinimumSpan(axis);
            sizeRequirements.minimum = (int)min;
            sizeRequirements.preferred = Math.max(sizeRequirements.minimum, (int)pref);
            sizeRequirements.maximum = Short.MAX_VALUE;
            sizeRequirements.alignment = 0.5f;
            return sizeRequirements;
        }
    }

    private class MyComponentView
    extends ComponentView {
        public MyComponentView(Element elem) {
            super(elem);
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (axis != 0 && axis != 1) {
                throw new IllegalArgumentException("Invalid axis: " + axis);
            }
            if (this.getComponent() != null) {
                Dimension size = this.getComponent().getPreferredSize();
                if (axis == 0) {
                    return SIPCommHTMLEditorKit.this.container.getWidth();
                }
                return size.height;
            }
            return 0.0f;
        }

        @Override
        public float getMaximumSpan(int axis) {
            if (axis != 0 && axis != 1) {
                throw new IllegalArgumentException("Invalid axis: " + axis);
            }
            if (this.getComponent() != null) {
                Dimension size = this.getComponent().getMaximumSize();
                if (axis == 0) {
                    return SIPCommHTMLEditorKit.this.container.getWidth();
                }
                return size.height;
            }
            return 0.0f;
        }
    }

    private class HTMLFactoryX
    extends HTMLEditorKit.HTMLFactory
    implements ViewFactory {
        private HTMLFactoryX() {
        }

        @Override
        public View create(Element elem) {
            View view = super.create(elem);
            SIPCommHTMLEditorKit.this.viewCreated(this, view);
            if (view instanceof ParagraphView) {
                return new ParagraphViewX(elem);
            }
            if (view instanceof ComponentView) {
                return new MyComponentView(elem);
            }
            return view;
        }
    }
}

