/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SelectedObject;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;

public class SIPCommMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private Object selectedObject;

    public SIPCommMenu() {
        this.init();
    }

    public SIPCommMenu(String text, Icon defaultIcon) {
        super(text);
        this.setIcon(defaultIcon);
        this.init();
    }

    public SIPCommMenu(String text) {
        super(text);
        this.init();
    }

    private void init() {
        MouseRolloverHandler mouseHandler = new MouseRolloverHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.getPopupMenu().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Container parent = SIPCommMenu.this.getParent();
                final Window parentWindow = parent instanceof JPopupMenu ? SwingUtilities.getWindowAncestor(((JPopupMenu)parent).getInvoker()) : SwingUtilities.getWindowAncestor(SIPCommMenu.this);
                if (!parentWindow.isActive()) {
                    SIPCommMenu.this.getPopupMenu().setVisible(false);
                }
                parentWindow.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                        JPopupMenu popupMenu = SIPCommMenu.this.getPopupMenu();
                        if (popupMenu != null && popupMenu.isVisible()) {
                            popupMenu.setVisible(false);
                        }
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        parentWindow.removeWindowListener(this);
                    }
                });
            }
        });
    }

    public void addItem(String text, Icon icon, ActionListener actionListener) {
        JMenuItem item = new JMenuItem(text, icon);
        item.addActionListener(actionListener);
        this.add(item);
    }

    public void setSelected(SelectedObject selectedObject) {
        if (selectedObject.getIcon() != null) {
            this.setIcon(selectedObject.getIcon());
        }
        if (selectedObject.getText() != null) {
            this.setText(selectedObject.getText());
        }
        if (selectedObject.getObject() != null) {
            this.setSelectedObject(selectedObject.getObject());
        }
    }

    public void setSelectedObject(Object o) {
        this.selectedObject = o;
    }

    public Object getSelectedObject() {
        return this.selectedObject;
    }

    public void setMouseOver(boolean isMouseOver) {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics g2 = g.create();
        try {
            this.internalPaintComponent(g2);
        }
        finally {
            g2.dispose();
        }
        super.paintComponent(g);
    }

    private void internalPaintComponent(Graphics g) {
        float visibility;
        AntialiasingManager.activateAntialiasing(g);
        FadeTracker fadeTracker = FadeTracker.getInstance();
        float f = visibility = this.getModel().isRollover() ? 1.0f : 0.0f;
        if (fadeTracker.isTracked((Component)this, FadeKind.ROLLOVER)) {
            visibility = fadeTracker.getFade((Component)this, FadeKind.ROLLOVER);
        }
        g.setColor(new Color(1.0f, 1.0f, 1.0f, visibility /= 2.0f));
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 20, 20);
        g.setColor(UIManager.getColor("Menu.foreground"));
    }

    private class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseRolloverHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (SIPCommMenu.this.isEnabled()) {
                SIPCommMenu.this.getModel().setRollover(false);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeOut(FadeKind.ROLLOVER, (Component)SIPCommMenu.this, true, (FadeTrackerCallback)new ButtonRepaintCallback());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SIPCommMenu.this.isEnabled()) {
                SIPCommMenu.this.getModel().setRollover(true);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeIn(FadeKind.ROLLOVER, (Component)SIPCommMenu.this, true, (FadeTrackerCallback)new ButtonRepaintCallback());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private class ButtonRepaintCallback
    implements FadeTrackerCallback {
        private ButtonRepaintCallback() {
        }

        public void fadeEnded(FadeKind arg0) {
            this.repaintLater();
        }

        public void fadePerformed(FadeKind arg0, float arg1) {
            this.repaintLater();
        }

        private void repaintLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SIPCommMenu.this.repaint();
                }
            });
        }

        public void fadeReversed(FadeKind arg0, boolean arg1, float arg2) {
        }
    }
}

