/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.plaf;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import net.java.sip.communicator.plugin.desktoputil.SIPCommLinkButton;

public class SIPCommLinkButtonUI
extends BasicButtonUI {
    private static final SIPCommLinkButtonUI ui = new SIPCommLinkButtonUI();

    public static ComponentUI createUI(JComponent jcomponent) {
        return ui;
    }

    @Override
    protected void paintText(Graphics g, JComponent com, Rectangle rect, String s) {
        SIPCommLinkButton bn = (SIPCommLinkButton)com;
        ButtonModel bnModel = bn.getModel();
        if (bnModel.isEnabled()) {
            if (bnModel.isPressed()) {
                bn.setForeground(bn.getActiveLinkColor());
            } else if (bn.isLinkVisited()) {
                bn.setForeground(bn.getVisitedLinkColor());
            } else {
                bn.setForeground(bn.getLinkColor());
            }
        } else if (bn.getDisabledLinkColor() != null) {
            bn.setForeground(bn.getDisabledLinkColor());
        }
        super.paintText(g, com, rect, s);
        int behaviour = bn.getLinkBehavior();
        if (!(behaviour == 1 && bnModel.isRollover() || behaviour == 0)) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int x = rect.x + this.getTextShiftOffset();
        int y = rect.y + fm.getAscent() + fm.getDescent() + this.getTextShiftOffset() - 1;
        if (bnModel.isEnabled()) {
            g.setColor(bn.getForeground());
            g.drawLine(x, y, x + rect.width - 1, y);
        } else {
            g.setColor(bn.getBackground().brighter());
            g.drawLine(x, y, x + rect.width - 1, y);
        }
    }
}

