/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.EncodingsRegistrationUtil;
import net.java.sip.communicator.util.UtilActivator;
import org.jitsi.service.neomedia.MediaConfigurationService;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.utils.MediaType;

public class EncodingsPanel
extends TransparentPanel {
    private static ResourceManagementService resourceService = UtilActivator.getResources();
    private final JCheckBox overrideCheckBox;
    private final MediaConfigurationService mediaConfiguration;
    private JPanel audioPanel;
    private Component audioControls;
    private JPanel videoPanel;
    private Component videoControls;
    private Map<String, String> encodingProperties = new HashMap<String, String>();
    private EncodingConfiguration encodingConfiguration;
    private JButton resetButton = new JButton(resourceService.getI18NString("plugin.jabberaccregwizz.RESET"));

    public EncodingsPanel() {
        super(new BorderLayout());
        this.overrideCheckBox = new SIPCommCheckBox(resourceService.getI18NString("plugin.jabberaccregwizz.OVERRIDE_ENCODINGS"), false);
        this.overrideCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EncodingsPanel.this.updateTableState();
            }
        });
        this.mediaConfiguration = UtilActivator.getMediaConfiguration();
        this.encodingConfiguration = this.mediaConfiguration.getMediaService().createEmptyEncodingConfiguration();
        this.encodingConfiguration.loadEncodingConfiguration(this.mediaConfiguration.getMediaService().getCurrentEncodingConfiguration());
        this.audioControls = this.mediaConfiguration.createEncodingControls(MediaType.AUDIO, this.encodingConfiguration);
        this.videoControls = this.mediaConfiguration.createEncodingControls(MediaType.VIDEO, this.encodingConfiguration);
        TransparentPanel mainPanel = new TransparentPanel();
        ((Container)((Object)mainPanel)).setLayout(new BoxLayout((Container)((Object)mainPanel), 1));
        this.add((Component)((Object)mainPanel), "North");
        TransparentPanel checkBoxPanel = new TransparentPanel(new BorderLayout());
        ((JComponent)((Object)checkBoxPanel)).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ((Container)((Object)checkBoxPanel)).add(this.overrideCheckBox, "West");
        this.resetButton.setToolTipText(resourceService.getI18NString("plugin.jabberaccregwizz.RESET_DESCRIPTION"));
        ((Container)((Object)checkBoxPanel)).add(this.resetButton, "East");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EncodingsPanel.this.encodingConfiguration.loadEncodingConfiguration(EncodingsPanel.this.mediaConfiguration.getMediaService().getCurrentEncodingConfiguration());
                EncodingsPanel.this.encodingConfiguration.storeProperties(EncodingsPanel.this.encodingProperties, "Encodings.");
                EncodingsPanel.this.resetTables();
            }
        });
        this.audioPanel = new TransparentPanel(new BorderLayout(10, 10));
        this.audioPanel.setBorder(BorderFactory.createTitledBorder(resourceService.getI18NString("plugin.jabberaccregwizz.AUDIO")));
        this.audioPanel.add(this.audioControls);
        this.videoPanel = new TransparentPanel(new BorderLayout(10, 10));
        this.videoPanel.setBorder(BorderFactory.createTitledBorder(resourceService.getI18NString("plugin.jabberaccregwizz.VIDEO")));
        this.videoPanel.add(this.videoControls);
        ((Container)((Object)mainPanel)).add((Component)((Object)checkBoxPanel));
        ((Container)((Object)mainPanel)).add(this.audioPanel);
        ((Container)((Object)mainPanel)).add(this.videoPanel);
    }

    public void commitPanel(EncodingsRegistrationUtil registration) {
        registration.setOverrideEncodings(this.overrideCheckBox.isSelected());
        this.encodingConfiguration.storeProperties(this.encodingProperties, "Encodings.");
        registration.setEncodingProperties(this.encodingProperties);
    }

    public void loadAccount(EncodingsRegistrationUtil encodingsReg) {
        this.overrideCheckBox.setSelected(encodingsReg.isOverrideEncodings());
        this.encodingConfiguration = encodingsReg.createEncodingConfig(this.mediaConfiguration.getMediaService());
        this.encodingConfiguration.storeProperties(this.encodingProperties);
        this.resetTables();
    }

    private void resetTables() {
        this.audioPanel.remove(this.audioControls);
        this.videoPanel.remove(this.videoControls);
        this.audioControls = this.mediaConfiguration.createEncodingControls(MediaType.AUDIO, this.encodingConfiguration);
        this.videoControls = this.mediaConfiguration.createEncodingControls(MediaType.VIDEO, this.encodingConfiguration);
        this.audioPanel.add(this.audioControls);
        this.videoPanel.add(this.videoControls);
        this.updateTableState();
    }

    private void updateTableState() {
        this.audioControls.setEnabled(this.overrideCheckBox.isSelected());
        this.videoControls.setEnabled(this.overrideCheckBox.isSelected());
    }
}

