/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.util.Hashtable;
import java.util.Map;
import org.jitsi.service.neomedia.RTPExtension;

public class DynamicRTPExtensionsRegistry {
    public static final int MIN_HEADER_ID = 1;
    public static final int MAX_ONE_BYTE_HEADER_ID = 14;
    public static final int MAX_TWO_BYTE_HEADER_ID = 255;
    private byte nextExtensionMapping = 1;
    private Map<RTPExtension, Byte> extMap = new Hashtable<RTPExtension, Byte>();

    public byte obtainExtensionMapping(RTPExtension extension) throws IllegalStateException {
        Byte extID = this.extMap.get(extension);
        if (extID == null) {
            extID = this.nextExtensionID();
            this.extMap.put(extension, extID);
        }
        return extID;
    }

    public byte getExtensionMapping(RTPExtension extension) {
        Byte extID = this.extMap.get(extension);
        if (extID == null) {
            return -1;
        }
        return extID;
    }

    public void addMapping(RTPExtension extension, byte extID) throws IllegalArgumentException {
        RTPExtension alreadyMappedExt = this.findExtension(extID);
        if (alreadyMappedExt != null) {
            throw new IllegalArgumentException(extID + " has already been allocated to " + alreadyMappedExt);
        }
        if (extID < 1) {
            throw new IllegalArgumentException(extID + " is not a valid RTP extensino header ID. (must be between " + 1 + " and " + 255);
        }
        this.extMap.put(extension, extID);
    }

    public RTPExtension findExtension(byte extID) {
        for (Map.Entry<RTPExtension, Byte> entry : this.extMap.entrySet()) {
            byte currentExtensionID = entry.getValue();
            if (currentExtensionID != extID) continue;
            return entry.getKey();
        }
        return null;
    }

    private byte nextExtensionID() throws IllegalStateException {
        byte extID;
        do {
            if (this.nextExtensionMapping < 0) {
                throw new IllegalStateException("Impossible to map more than the 255 already mapped  RTP extensions");
            }
            this.nextExtensionMapping = (byte)(this.nextExtensionMapping + 1);
        } while (this.findExtension(extID) != null);
        return extID;
    }

    public Map<RTPExtension, Byte> getMappings() {
        return new Hashtable<RTPExtension, Byte>(this.extMap);
    }
}

