/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.build.incremental;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

public class ThreadBuildContext
implements BuildContext {
    private static final ThreadLocal threadContext = new ThreadLocal();
    private static final DefaultBuildContext defaultContext = new DefaultBuildContext();

    public static BuildContext getContext() {
        BuildContext context = (BuildContext)threadContext.get();
        if (context == null) {
            context = defaultContext;
        }
        return context;
    }

    public static void setThreadBuildContext(BuildContext context) {
        threadContext.set(context);
    }

    public boolean hasDelta(String relPath) {
        return ThreadBuildContext.getContext().hasDelta(relPath);
    }

    public boolean hasDelta(List relPaths) {
        return ThreadBuildContext.getContext().hasDelta(relPaths);
    }

    public Scanner newDeleteScanner(File basedir) {
        return ThreadBuildContext.getContext().newDeleteScanner(basedir);
    }

    public OutputStream newFileOutputStream(File file) throws IOException {
        return ThreadBuildContext.getContext().newFileOutputStream(file);
    }

    public Scanner newScanner(File basedir) {
        return ThreadBuildContext.getContext().newScanner(basedir);
    }

    public Scanner newScanner(File basedir, boolean ignoreDelta) {
        return ThreadBuildContext.getContext().newScanner(basedir, ignoreDelta);
    }

    public void refresh(File file) {
        ThreadBuildContext.getContext().refresh(file);
    }

    public Object getValue(String key) {
        return ThreadBuildContext.getContext().getValue(key);
    }

    public boolean isIncremental() {
        return ThreadBuildContext.getContext().isIncremental();
    }

    public void setValue(String key, Object value) {
        ThreadBuildContext.getContext().setValue(key, value);
    }
}

