/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.dtmf;

import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.sip.ClientTransaction;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.TransactionUnavailableException;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorAdapter;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.DTMFListener;
import net.java.sip.communicator.service.protocol.event.DTMFReceivedEvent;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.DTMFTone;

public class DTMFInfo
extends MethodProcessorAdapter {
    private static final Logger logger = Logger.getLogger(DTMFInfo.class);
    private static final String CONTENT_SUB_TYPE = "dtmf-relay";
    private static final String CONTENT_TYPE = "application";
    private Hashtable<CallPeer, Object[]> currentlyTransmittingTones = new Hashtable();
    private final ProtocolProviderServiceSipImpl pps;
    private final List<DTMFListener> dtmfListeners = new LinkedList<DTMFListener>();

    public DTMFInfo(ProtocolProviderServiceSipImpl pps) {
        this.pps = pps;
        this.pps.registerMethodProcessor("INFO", this);
    }

    public void startSendingDTMF(CallPeerSipImpl callPeer, DTMFTone tone) throws OperationFailedException, NullPointerException, IllegalArgumentException {
        if (this.currentlyTransmittingTones.contains((Object)callPeer)) {
            throw new IllegalStateException("Error starting dtmf tone, already started");
        }
        this.currentlyTransmittingTones.put((CallPeer)callPeer, new Object[]{tone, System.currentTimeMillis()});
    }

    public void stopSendingDTMF(CallPeerSipImpl callPeer) {
        Object[] toneInfo = this.currentlyTransmittingTones.remove((Object)callPeer);
        if (toneInfo != null) {
            try {
                long startTime = (Long)toneInfo[1];
                this.sayInfo(callPeer, (DTMFTone)toneInfo[0], System.currentTimeMillis() - startTime);
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"Error stoping dtmf ");
            }
        }
    }

    private void sayInfo(CallPeerSipImpl callPeer, DTMFTone dtmftone, long duration) throws OperationFailedException {
        Request info = this.pps.getMessageFactory().createRequest(callPeer.getDialog(), "INFO");
        ContentType ct = new ContentType(CONTENT_TYPE, CONTENT_SUB_TYPE);
        String content = "Signal=" + dtmftone.getValue() + "\r\nDuration=" + duration + "\r\n";
        ContentLength cl = new ContentLength(content.length());
        info.setContentLength((ContentLengthHeader)cl);
        try {
            info.setContent((Object)content.getBytes(), (ContentTypeHeader)ct);
        }
        catch (ParseException ex) {
            logger.error((Object)"Failed to construct the INFO request", (Throwable)ex);
            throw new OperationFailedException("Failed to construct a client the INFO request", 4, (Throwable)ex);
        }
        ClientTransaction clientTransaction = null;
        try {
            clientTransaction = callPeer.getJainSipProvider().getNewClientTransaction(info);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Failed to construct a client transaction from the INFO request", (Throwable)ex);
            throw new OperationFailedException("Failed to construct a client transaction from the INFO request", 4, (Throwable)ex);
        }
        try {
            if (callPeer.getDialog().getState() == DialogState.TERMINATED) {
                logger.warn((Object)"Trying to send a dtmf tone inside a TERMINATED dialog.");
                return;
            }
            callPeer.getDialog().sendRequest(clientTransaction);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent request:\n" + info));
            }
        }
        catch (SipException ex) {
            throw new OperationFailedException("Failed to send the INFO request", 2, (Throwable)ex);
        }
    }

    @Override
    public boolean processResponse(ResponseEvent responseEvent) {
        boolean processed = false;
        if (responseEvent == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"null responseEvent");
            }
        } else {
            Response response = responseEvent.getResponse();
            if (response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"null response");
                }
            } else {
                ClientTransaction clientTransaction = responseEvent.getClientTransaction();
                if (clientTransaction == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"null clientTransaction");
                    }
                } else {
                    Request request = clientTransaction.getRequest();
                    if (request == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"null request");
                        }
                    } else {
                        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
                        if (contentTypeHeader != null && CONTENT_TYPE.equalsIgnoreCase(contentTypeHeader.getContentType()) && CONTENT_SUB_TYPE.equalsIgnoreCase(contentTypeHeader.getContentSubType())) {
                            processed = true;
                            int statusCode = response.getStatusCode();
                            if (statusCode == 200) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("DTMF send succeeded: " + statusCode));
                                }
                            } else {
                                logger.error((Object)("DTMF send failed: " + statusCode));
                            }
                        }
                    }
                }
            }
        }
        return processed;
    }

    @Override
    public boolean processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
        if (contentTypeHeader != null && CONTENT_TYPE.equalsIgnoreCase(contentTypeHeader.getContentType()) && CONTENT_SUB_TYPE.equalsIgnoreCase(contentTypeHeader.getContentSubType())) {
            Response responseOK;
            try {
                byte[] value;
                Object valueObj = request.getContent();
                if (valueObj instanceof String) {
                    value = ((String)valueObj).getBytes("UTF-8");
                } else if (valueObj instanceof byte[]) {
                    value = (byte[])valueObj;
                } else {
                    logger.error((Object)"Unknown content type");
                    return false;
                }
                Properties prop = new Properties();
                prop.load(new ByteArrayInputStream(value));
                String signal = prop.getProperty("Signal");
                String durationStr = prop.getProperty("Duration");
                DTMFTone tone = DTMFTone.getDTMFTone((String)signal);
                if (tone == null) {
                    logger.warn((Object)("Unknown tone received: " + tone));
                    return false;
                }
                long duration = 0L;
                try {
                    duration = Long.parseLong(durationStr);
                }
                catch (NumberFormatException ex) {
                    logger.warn((Object)("Error parsing duration:" + durationStr), (Throwable)ex);
                }
                this.fireToneEvent(tone, duration);
            }
            catch (IOException value) {
                // empty catch block
            }
            try {
                responseOK = this.pps.getMessageFactory().createResponse(200, requestEvent.getRequest());
            }
            catch (ParseException ex) {
                logger.warn((Object)"Failed to create OK for incoming INFO request", (Throwable)ex);
                return false;
            }
            try {
                SipStackSharing.getOrCreateServerTransaction(requestEvent).sendResponse(responseOK);
            }
            catch (TransactionUnavailableException ex) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Failed to respond to an incoming transactionless INFO request");
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Exception was:", (Throwable)ex);
                }
                return false;
            }
            catch (InvalidArgumentException ex) {
                logger.warn((Object)"Failed to send OK for incoming INFO request", (Throwable)ex);
                return false;
            }
            catch (SipException ex) {
                logger.warn((Object)"Failed to send OK for incoming INFO request", (Throwable)ex);
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireToneEvent(DTMFTone tone, long duration) {
        ArrayList<DTMFListener> listeners;
        List<DTMFListener> list = this.dtmfListeners;
        synchronized (list) {
            listeners = new ArrayList<DTMFListener>(this.dtmfListeners);
        }
        DTMFReceivedEvent evt = new DTMFReceivedEvent((Object)this.pps, tone, duration);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching DTMFTone Listeners=" + listeners.size() + " evt=" + evt));
        }
        try {
            for (DTMFListener listener : listeners) {
                listener.toneReceived(evt);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Error delivering dtmf tone", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDTMFListener(DTMFListener listener) {
        List<DTMFListener> list = this.dtmfListeners;
        synchronized (list) {
            if (!this.dtmfListeners.contains(listener)) {
                this.dtmfListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDTMFListener(DTMFListener listener) {
        List<DTMFListener> list = this.dtmfListeners;
        synchronized (list) {
            this.dtmfListeners.remove(listener);
        }
    }
}

