/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.jbosh;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.ApacheHTTPResponse;
import org.igniterealtime.jbosh.BOSHClientConfig;
import org.igniterealtime.jbosh.CMSessionParams;
import org.igniterealtime.jbosh.HTTPResponse;
import org.igniterealtime.jbosh.HTTPSender;

final class ApacheHTTPSender
implements HTTPSender {
    private final Lock lock = new ReentrantLock();
    private BOSHClientConfig cfg;
    private HttpClient httpClient;

    ApacheHTTPSender() {
        HttpClient.class.getName();
    }

    @Override
    public void init(BOSHClientConfig session) {
        this.lock.lock();
        try {
            this.cfg = session;
            this.httpClient = ApacheHTTPSender.initHttpClient(session);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void destroy() {
        this.lock.lock();
        try {
            if (this.httpClient != null) {
                this.httpClient.getConnectionManager().shutdown();
            }
        }
        finally {
            this.cfg = null;
            this.httpClient = null;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPResponse send(CMSessionParams params, AbstractBody body) {
        BOSHClientConfig mCfg;
        HttpClient mClient;
        this.lock.lock();
        try {
            if (this.httpClient == null) {
                this.httpClient = ApacheHTTPSender.initHttpClient(this.cfg);
            }
            mClient = this.httpClient;
            mCfg = this.cfg;
        }
        finally {
            this.lock.unlock();
        }
        return new ApacheHTTPResponse(mClient, mCfg, params, body);
    }

    private static synchronized HttpClient initHttpClient(BOSHClientConfig config) {
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)100);
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        if (config != null && config.getProxyHost() != null && config.getProxyPort() != 0) {
            HttpHost proxy = new HttpHost(config.getProxyHost(), config.getProxyPort());
            params.setParameter("http.route.default-proxy", (Object)proxy);
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslFactory = SSLSocketFactory.getSocketFactory();
        sslFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        schemeRegistry.register(new Scheme("https", (SocketFactory)sslFactory, 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        return new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
    }
}

