/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Collection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.workgroup.packet.AgentInfo;
import org.jivesoftware.smackx.workgroup.packet.AgentWorkgroups;
import org.jxmpp.jid.Jid;

public class Agent {
    private XMPPConnection connection;
    private Jid workgroupJID;

    public static Collection<String> getWorkgroups(Jid serviceJID, Jid agentJID, XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AgentWorkgroups request = new AgentWorkgroups(agentJID);
        request.setTo(serviceJID);
        AgentWorkgroups response = (AgentWorkgroups)connection.createStanzaCollectorAndSend((IQ)request).nextResultOrThrow();
        return response.getWorkgroups();
    }

    Agent(XMPPConnection connection, Jid workgroupJID) {
        this.connection = connection;
        this.workgroupJID = workgroupJID;
    }

    public Jid getUser() {
        return this.connection.getUser();
    }

    public String getName() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setType(IQ.Type.get);
        agentInfo.setTo(this.workgroupJID);
        agentInfo.setFrom(this.getUser());
        AgentInfo response = (AgentInfo)this.connection.createStanzaCollectorAndSend((IQ)agentInfo).nextResultOrThrow();
        return response.getName();
    }

    public void setName(String newName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setType(IQ.Type.set);
        agentInfo.setTo(this.workgroupJID);
        agentInfo.setFrom(this.getUser());
        agentInfo.setName(newName);
        this.connection.createStanzaCollectorAndSend((IQ)agentInfo).nextResultOrThrow();
    }
}

