/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingle;

import java.util.ArrayList;
import java.util.List;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;

public class SourceGroupPacketExtension
extends AbstractPacketExtension {
    public static final String ELEMENT_NAME = "ssrc-group";
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:ssma:0";
    public static final String SEMANTICS_ATTR_NAME = "semantics";
    public static final String SEMANTICS_SIMULCAST = "SIM";
    public static final String SEMANTICS_FID = "FID";
    public static final String SEMANTICS_FEC = "FEC-FR";

    public static SourceGroupPacketExtension createSimulcastGroup() {
        SourceGroupPacketExtension simulcastGroupPe = new SourceGroupPacketExtension();
        simulcastGroupPe.setSemantics(SEMANTICS_SIMULCAST);
        return simulcastGroupPe;
    }

    public SourceGroupPacketExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public SourceGroupPacketExtension(String elementName) {
        super(NAMESPACE, elementName);
    }

    public String getSemantics() {
        return this.getAttributeAsString(SEMANTICS_ATTR_NAME);
    }

    public void setSemantics(String semantics) {
        this.setAttribute(SEMANTICS_ATTR_NAME, semantics);
    }

    public List<SourcePacketExtension> getSources() {
        return this.getChildExtensionsOfType(SourcePacketExtension.class);
    }

    public void addSources(List<SourcePacketExtension> sources) {
        if (sources != null && sources.size() != 0) {
            for (SourcePacketExtension source : sources) {
                this.addChildExtension(source);
            }
        }
    }

    public SourceGroupPacketExtension copy() {
        SourceGroupPacketExtension copy = AbstractPacketExtension.clone(this);
        copy.setSemantics(this.getSemantics());
        List<SourcePacketExtension> sources = this.getSources();
        ArrayList<SourcePacketExtension> sourcesCopy = new ArrayList<SourcePacketExtension>(sources.size());
        for (SourcePacketExtension source : sources) {
            sourcesCopy.add(source.copy());
        }
        copy.addSources(sourcesCopy);
        return copy;
    }
}

