/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.thumbnail;

import org.jivesoftware.smack.util.SHA1;
import org.jivesoftware.smackx.bob.BoBHash;
import org.xmlpull.v1.XmlPullParser;

public class Thumbnail {
    public static final String ELEMENT_NAME = "thumbnail";
    public static final String NAMESPACE = "urn:xmpp:thumbs:0";
    public static final String CID = "cid";
    public static final String MIME_TYPE = "mime-type";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    private BoBHash cid;
    private String mimeType;
    private int width;
    private int height;

    public Thumbnail(byte[] thumbnailData, String mimeType, int width, int height) {
        this.cid = this.createCid(thumbnailData);
        this.mimeType = mimeType;
        this.width = width;
        this.height = height;
    }

    public Thumbnail(XmlPullParser parser) {
        this.cid = this.parseCid(parser.getAttributeValue("", CID));
        this.mimeType = parser.getAttributeValue("", MIME_TYPE);
        String parserWidth = parser.getAttributeValue("", WIDTH);
        String parserHeight = parser.getAttributeValue("", HEIGHT);
        try {
            this.width = Integer.parseInt(parserWidth);
            this.height = Integer.parseInt(parserHeight);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private BoBHash parseCid(String cid) {
        if (!cid.endsWith("@bob.xmpp.org")) {
            cid = cid.substring(0, cid.indexOf(64)) + "@bob.xmpp.org";
        }
        return BoBHash.fromCid((String)cid);
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\"");
        buf = this.addXmlAttribute(buf, CID, this.getCid().getCid());
        buf = this.addXmlAttribute(buf, MIME_TYPE, this.getMimeType());
        buf = this.addXmlIntAttribute(buf, WIDTH, this.getWidth());
        buf = this.addXmlIntAttribute(buf, HEIGHT, this.getWidth());
        buf.append("/>");
        return buf.toString();
    }

    public BoBHash getCid() {
        return this.cid;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setCid(BoBHash cid) {
        this.cid = cid;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    private StringBuffer addXmlAttribute(StringBuffer buff, String attrName, String attrValue) {
        buff.append(" " + attrName + "=\"").append(attrValue).append("\"");
        return buff;
    }

    private StringBuffer addXmlIntAttribute(StringBuffer buff, String attrName, int attrValue) {
        return this.addXmlAttribute(buff, attrName, String.valueOf(attrValue));
    }

    private BoBHash createCid(byte[] thumbnailData) {
        return new BoBHash(SHA1.hex((byte[])thumbnailData), "sha1");
    }
}

