/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class MavenProjectValueSource
implements ValueSource {
    private MavenProject project;
    private boolean escapedBackslashesInFilePath;
    private MavenResourcesExecution mavenResourcesExecution;

    public MavenProjectValueSource(MavenProject mavenProject) {
        this(mavenProject, false);
    }

    public MavenProjectValueSource(MavenProject mavenProject, boolean escapedBackslashesInFilePath) {
        this.project = mavenProject;
        this.escapedBackslashesInFilePath = escapedBackslashesInFilePath;
    }

    public MavenProjectValueSource(MavenProject mavenProject, boolean escapedBackslashesInFilePath, MavenResourcesExecution mavenResourcesExecution) {
        this.project = mavenProject;
        this.escapedBackslashesInFilePath = escapedBackslashesInFilePath;
        this.mavenResourcesExecution = mavenResourcesExecution;
    }

    public Object getValue(String expression) {
        if (expression == null || StringUtils.isEmpty((String)expression.toString())) {
            return null;
        }
        Object value = null;
        try {
            value = ReflectionValueExtractor.evaluate((String)("" + expression), (Object)this.project, (boolean)this.isProjectExpression(expression));
            if (this.escapedBackslashesInFilePath && value != null && "java.lang.String".equals(value.getClass().getName())) {
                String val = (String)value;
                value = FilteringUtils.escapeWindowsPath(val);
            } else if (this.escapedBackslashesInFilePath && value != null && File.class.getName().equals(value.getClass().getName())) {
                String val = ((File)value).getPath();
                value = FilteringUtils.escapeWindowsPath(val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private boolean isProjectExpression(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return false;
        }
        if (this.mavenResourcesExecution != null) {
            return this.mavenResourcesExecution.getProjectStartExpressions().contains(key);
        }
        return key.startsWith("project.") || key.startsWith("pom.");
    }

    public void clearFeedback() {
    }

    public List getFeedback() {
        return Collections.EMPTY_LIST;
    }
}

