/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.jabber.JabberChatRoomMember;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.Occupant;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;

public class ChatRoomMemberJabberImpl
implements JabberChatRoomMember {
    private final ChatRoomJabberImpl containingRoom;
    private ChatRoomMemberRole role;
    private final Jid jabberID;
    private Resourcepart nickName;
    private String email;
    private String avatarUrl;
    private String statisticsID;
    private Contact contact;
    private byte[] avatar;
    private String displayName;
    private Presence lastPresence = null;

    public ChatRoomMemberJabberImpl(ChatRoomJabberImpl containingChatRoom, Resourcepart nickName, Jid jabberID) {
        this.jabberID = jabberID;
        this.nickName = nickName;
        this.containingRoom = containingChatRoom;
        OperationSetPersistentPresenceJabberImpl presenceOpSet = (OperationSetPersistentPresenceJabberImpl)containingChatRoom.getParentProvider().getOperationSet(OperationSetPersistentPresence.class);
        this.contact = presenceOpSet.findContactByID(jabberID.asBareJid().toString());
        if (this.contact != null) {
            this.avatar = this.contact.getImage();
        }
        this.getRole();
    }

    public ChatRoom getChatRoom() {
        return this.containingRoom;
    }

    public Jid getJabberID() {
        return this.jabberID;
    }

    public String getContactAddress() {
        return this.jabberID.toString();
    }

    public String getName() {
        return this.nickName.toString();
    }

    public Resourcepart getNameAsResourcepart() {
        return this.nickName;
    }

    protected void setName(Resourcepart newNick) {
        if (newNick == null || newNick.length() <= 0) {
            throw new IllegalArgumentException("a room member nickname could not be null");
        }
        this.nickName = newNick;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.containingRoom.getParentProvider();
    }

    public ChatRoomMemberRole getRole() {
        if (this.role == null) {
            Occupant o = this.containingRoom.getMultiUserChat().getOccupant(JidCreate.entityFullFrom((EntityBareJid)this.containingRoom.getIdentifierAsJid(), (Resourcepart)this.nickName));
            if (o == null) {
                return ChatRoomMemberRole.GUEST;
            }
            this.role = ChatRoomJabberImpl.smackRoleToScRole(o.getRole(), o.getAffiliation());
        }
        return this.role;
    }

    ChatRoomMemberRole getCurrentRole() {
        return this.role;
    }

    public void setRole(ChatRoomMemberRole role) {
        this.role = role;
    }

    public byte[] getAvatar() {
        return this.avatar;
    }

    public void setAvatar(byte[] avatar) {
        this.avatar = avatar;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public PresenceStatus getPresenceStatus() {
        return ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getJabberStatusEnum().getStatus("Available");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEmail() {
        return this.email;
    }

    void setEmail(String email) {
        this.email = email;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getStatisticsID() {
        return this.statisticsID;
    }

    void setStatisticsID(String id) {
        this.statisticsID = id;
    }

    public void setLastPresence(Presence presence) {
        this.lastPresence = presence;
    }

    public Presence getLastPresence() {
        return this.lastPresence;
    }
}

