/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.sip.communicator.impl.protocol.jabber.ContactResourceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ServerStoredContactListJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractContact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactResourceEvent;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;

public class ContactJabberImpl
extends AbstractContact {
    private Jid jid = null;
    private byte[] image = null;
    private PresenceStatus status;
    private final ServerStoredContactListJabberImpl ssclCallback;
    private boolean isPersistent = false;
    private boolean isResolved = false;
    private final Jid tempId;
    private String statusMessage = null;
    private String serverDisplayName = null;
    private Map<FullJid, ContactResourceJabberImpl> resources = null;
    private boolean mobile = false;
    private boolean isLocal = false;

    ContactJabberImpl(RosterEntry rosterEntry, ServerStoredContactListJabberImpl ssclCallback, boolean isPersistent, boolean isResolved) {
        if (rosterEntry != null) {
            this.jid = rosterEntry.getJid();
            this.serverDisplayName = rosterEntry.getName();
        }
        this.tempId = null;
        this.ssclCallback = ssclCallback;
        this.isPersistent = isPersistent;
        this.isResolved = isResolved;
        this.status = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getJabberStatusEnum().getStatus("Offline");
    }

    ContactJabberImpl(Jid id, ServerStoredContactListJabberImpl ssclCallback, boolean isPersistent) {
        this.tempId = id;
        this.ssclCallback = ssclCallback;
        this.isPersistent = isPersistent;
        this.isResolved = false;
        this.status = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getJabberStatusEnum().getStatus("Offline");
    }

    public String getAddress() {
        if (this.isResolved) {
            return this.jid.toString();
        }
        return this.tempId.toString();
    }

    Jid getAddressAsJid() {
        if (this.isResolved) {
            return this.jid;
        }
        return this.tempId;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public byte[] getImage() {
        return this.getImage(true);
    }

    public byte[] getImage(boolean retrieveIfNecessary) {
        if (this.image == null && retrieveIfNecessary) {
            this.ssclCallback.addContactForImageUpdate(this);
        }
        return this.image;
    }

    public void setImage(byte[] imgBytes) {
        this.image = imgBytes;
    }

    public int hashCode() {
        return this.getAddress().toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        int atIndex;
        if (obj == null || !(obj instanceof String) && !(obj instanceof ContactJabberImpl)) {
            return false;
        }
        if (obj instanceof ContactJabberImpl && ((ContactJabberImpl)((Object)obj)).getAddress().equalsIgnoreCase(this.getAddress()) && ((ContactJabberImpl)((Object)obj)).getProtocolProvider() == this.getProtocolProvider()) {
            return true;
        }
        return obj instanceof String && ((atIndex = this.getAddress().indexOf("@")) > 0 ? this.getAddress().equalsIgnoreCase((String)obj) || this.getAddress().substring(0, atIndex).equalsIgnoreCase((String)obj) : this.getAddress().equalsIgnoreCase((String)obj));
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("JabberContact[ id=");
        buff.append(this.getAddress()).append(", isPersistent=").append(this.isPersistent).append(", isResolved=").append(this.isResolved).append("]");
        return buff.toString();
    }

    void updatePresenceStatus(PresenceStatus status) {
        this.status = status;
    }

    public PresenceStatus getPresenceStatus() {
        return this.status;
    }

    public String getDisplayName() {
        if (this.isResolved) {
            RosterEntry entry = this.ssclCallback.getRosterEntry(this.jid.asBareJid());
            String name = null;
            if (entry != null) {
                name = entry.getName();
            }
            if (name != null && name.trim().length() != 0) {
                return name;
            }
        }
        return this.getAddress();
    }

    String getServerDisplayName() {
        return this.serverDisplayName;
    }

    void setServerDisplayName(String newValue) {
        this.serverDisplayName = newValue;
    }

    public ContactGroup getParentContactGroup() {
        return this.ssclCallback.findContactGroup(this);
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.ssclCallback.getParentProvider();
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    void setPersistent(boolean persistent) {
        this.isPersistent = persistent;
    }

    void setResolved(RosterEntry entry) {
        if (this.isResolved) {
            return;
        }
        this.isResolved = true;
        this.isPersistent = true;
        this.jid = entry.getJid();
        this.serverDisplayName = entry.getName();
    }

    public String getPersistentData() {
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    RosterEntry getSourceEntry() {
        if (this.jid == null) {
            return null;
        }
        return this.ssclCallback.getRosterEntry(this.jid.asBareJid());
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    protected void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public boolean supportResources() {
        return true;
    }

    public Collection<ContactResource> getResources() {
        if (this.resources != null) {
            return new ArrayList<ContactResource>(this.resources.values());
        }
        return null;
    }

    ContactResource getResourceFromJid(Jid jid) {
        return this.resources.get(jid);
    }

    Map<FullJid, ContactResourceJabberImpl> getResourcesMap() {
        if (this.resources == null) {
            this.resources = new ConcurrentHashMap<FullJid, ContactResourceJabberImpl>();
        }
        return this.resources;
    }

    public void fireContactResourceEvent(ContactResourceEvent event) {
        super.fireContactResourceEvent(event);
    }

    protected void setJid(Jid fullJid) {
        this.jid = fullJid;
        if (this.resources == null) {
            this.resources = new ConcurrentHashMap<FullJid, ContactResourceJabberImpl>();
        }
    }

    public boolean isMobile() {
        return this.getPresenceStatus().isOnline() && this.mobile;
    }

    void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }
}

