/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ScServiceDiscoveryManager;
import net.java.sip.communicator.impl.protocol.jabber.caps.UserCapsNodeListener;
import net.java.sip.communicator.service.protocol.AbstractOperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.OperationSetMessageCorrection;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.Roster;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OperationSetContactCapabilitiesJabberImpl
extends AbstractOperationSetContactCapabilities<ProtocolProviderServiceJabberImpl>
implements UserCapsNodeListener,
ContactPresenceStatusListener {
    private static final Logger logger = Logger.getLogger(OperationSetContactCapabilitiesJabberImpl.class);
    public static final String PROP_XMPP_USE_ALL_RESOURCES_FOR_CAPABILITIES = "net.java.sip.communicator.XMPP_USE_ALL_RESOURCES_FOR_CAPABILITIES";
    public static final boolean USE_ALL_RESOURCES_FOR_CAPABILITIES_DEFAULT = true;
    private static final Set<Class<? extends OperationSet>> OFFLINE_OPERATION_SETS = new HashSet<Class<? extends OperationSet>>();
    private static final Map<Class<? extends OperationSet>, String[]> OPERATION_SETS_TO_FEATURES = new HashMap<Class<? extends OperationSet>, String[]>();
    private ScServiceDiscoveryManager discoveryManager;

    public OperationSetContactCapabilitiesJabberImpl(ProtocolProviderServiceJabberImpl parentProvider) {
        super((ProtocolProviderService)parentProvider);
        OperationSetPresence presenceOpSet = (OperationSetPresence)parentProvider.getOperationSet(OperationSetPresence.class);
        if (presenceOpSet != null) {
            presenceOpSet.addContactPresenceStatusListener((ContactPresenceStatusListener)this);
        }
    }

    protected <U extends OperationSet> U getOperationSet(Contact contact, Class<U> opsetClass, boolean online) {
        Jid jid = this.jidFromContact(contact);
        if (jid == null) {
            return null;
        }
        return this.getOperationSet(jid, opsetClass, online);
    }

    protected Map<String, OperationSet> getSupportedOperationSets(Contact contact, boolean online) {
        Jid jid = this.jidFromContact(contact);
        if (jid == null) {
            return null;
        }
        return this.getSupportedOperationSets(jid, online);
    }

    private Jid jidFromContact(Contact contact) {
        try {
            Jid jid = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getFullJid(contact);
            if (jid != null) {
                return jid;
            }
            return JidCreate.from((String)contact.getAddress());
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    private Map<String, OperationSet> getSupportedOperationSets(Jid jid, boolean online) {
        Map supportedOperationSets = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getSupportedOperationSets();
        int supportedOperationSetCount = supportedOperationSets.size();
        HashMap<String, OperationSet> contactSupportedOperationSets = new HashMap<String, OperationSet>(supportedOperationSetCount);
        if (supportedOperationSetCount != 0) {
            for (Map.Entry supportedOperationSetEntry : supportedOperationSets.entrySet()) {
                Object opset;
                Class<?> opsetClass;
                String opsetClassName = (String)supportedOperationSetEntry.getKey();
                try {
                    opsetClass = Class.forName(opsetClassName);
                }
                catch (ClassNotFoundException cnfex) {
                    opsetClass = null;
                    logger.error((Object)("Failed to get OperationSet class for name: " + opsetClassName), (Throwable)cnfex);
                }
                if (opsetClass == null || (opset = this.getOperationSet(jid, opsetClass, online)) == null) continue;
                contactSupportedOperationSets.put(opsetClassName, (OperationSet)opset);
            }
        }
        return contactSupportedOperationSets;
    }

    protected Map<String, OperationSet> getLargestSupportedOperationSet(List<Jid> fullJids) {
        Map<String, OperationSet> supportedOperationSets = new HashMap<String, OperationSet>();
        if (fullJids != null) {
            for (Jid fullJid : fullJids) {
                Map<String, OperationSet> newSupportedOperationSets = this.getSupportedOperationSets(fullJid, true);
                if (newSupportedOperationSets.size() <= supportedOperationSets.size()) continue;
                supportedOperationSets = newSupportedOperationSets;
            }
        }
        return supportedOperationSets;
    }

    private <U extends OperationSet> U getOperationSet(Jid jid, Class<U> opsetClass, boolean online) {
        String[] features;
        OperationSet opset = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(opsetClass);
        if (opset == null) {
            return null;
        }
        if (!online) {
            return (U)(OFFLINE_OPERATION_SETS.contains(opsetClass) ? opset : null);
        }
        if (OPERATION_SETS_TO_FEATURES.containsKey(opsetClass) && ((features = OPERATION_SETS_TO_FEATURES.get(opsetClass)) == null || features.length != 0 && !((ProtocolProviderServiceJabberImpl)this.parentProvider).isFeatureListSupported(jid, features))) {
            opset = null;
        }
        return (U)opset;
    }

    void setDiscoveryManager(ScServiceDiscoveryManager discoveryManager) {
        if (this.discoveryManager != discoveryManager) {
            if (this.discoveryManager != null) {
                this.discoveryManager.removeUserCapsNodeListener(this);
            }
            this.discoveryManager = discoveryManager;
            if (this.discoveryManager != null) {
                this.discoveryManager.addUserCapsNodeListener(this);
            }
        }
    }

    @Override
    public void userCapsNodeAdded(Jid user, List<Jid> fullJids, String node, boolean online) {
        this.userCapsNodeChanged(user, fullJids, online);
    }

    @Override
    public void userCapsNodeRemoved(Jid user, List<Jid> fullJids, String node, boolean online) {
        this.userCapsNodeChanged(user, fullJids, online);
    }

    private void userCapsNodeChanged(Jid user, List<Jid> fullJids, boolean online) {
        OperationSetPresence opsetPresence = (OperationSetPresence)((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(OperationSetPresence.class);
        if (opsetPresence != null) {
            if (JabberActivator.getConfigurationService().getBoolean(PROP_XMPP_USE_ALL_RESOURCES_FOR_CAPABILITIES, true) && !fullJids.isEmpty()) {
                Contact contact = opsetPresence.findContactByID(user.asBareJid().toString());
                if (contact != null) {
                    this.fireContactCapabilitiesEvent(contact, 1, this.getLargestSupportedOperationSet(fullJids));
                }
            } else {
                Contact contact = opsetPresence.findContactByID(user.asBareJid().toString());
                if (contact != null) {
                    if (online) {
                        this.fireContactCapabilitiesEvent(contact, 1, this.getSupportedOperationSets(user, true));
                    } else {
                        this.fireContactCapabilitiesEvent(contact, 1, this.getSupportedOperationSets(contact));
                    }
                }
            }
        }
    }

    public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
        if (this.discoveryManager != null && evt.getNewStatus().getStatus() < 20 && !evt.isResourceChanged()) {
            this.discoveryManager.removeContactCapsNode(evt.getSourceContact());
        }
    }

    public void fireContactCapabilitiesChanged(BareJid user, List<Jid> fullJids) {
        if (!JabberActivator.getConfigurationService().getBoolean(PROP_XMPP_USE_ALL_RESOURCES_FOR_CAPABILITIES, true) || fullJids.isEmpty()) {
            OperationSetPresence opsetPresence = (OperationSetPresence)((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(OperationSetPresence.class);
            if (opsetPresence != null) {
                Contact contact = opsetPresence.findContactByID(user.toString());
                Presence presence = Roster.getInstanceFor((XMPPConnection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection()).getPresence(user);
                if (contact != null) {
                    this.fireContactCapabilitiesEvent(contact, 1, this.getSupportedOperationSets((Jid)user, presence.isAvailable()));
                }
            }
        } else {
            Contact contact;
            OperationSetPresence opsetPresence = (OperationSetPresence)((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(OperationSetPresence.class);
            if (opsetPresence != null && (contact = opsetPresence.findContactByID(user.asBareJid().toString())) != null) {
                this.fireContactCapabilitiesEvent(contact, 1, this.getLargestSupportedOperationSet(fullJids));
            }
        }
    }

    static {
        OFFLINE_OPERATION_SETS.add(OperationSetBasicInstantMessaging.class);
        OFFLINE_OPERATION_SETS.add(OperationSetMessageCorrection.class);
        OFFLINE_OPERATION_SETS.add(OperationSetServerStoredContactInfo.class);
        OPERATION_SETS_TO_FEATURES.put(OperationSetBasicTelephony.class, new String[]{"urn:xmpp:jingle:1", "urn:xmpp:jingle:apps:rtp:1", "urn:xmpp:jingle:apps:rtp:audio"});
        OPERATION_SETS_TO_FEATURES.put(OperationSetVideoTelephony.class, new String[]{"urn:xmpp:jingle:1", "urn:xmpp:jingle:apps:rtp:1", "urn:xmpp:jingle:apps:rtp:video"});
        OPERATION_SETS_TO_FEATURES.put(OperationSetDesktopSharingServer.class, new String[]{"urn:xmpp:jingle:1", "urn:xmpp:jingle:apps:rtp:1", "urn:xmpp:jingle:apps:rtp:video"});
        OPERATION_SETS_TO_FEATURES.put(OperationSetMessageCorrection.class, new String[]{"urn:xmpp:message-correct:0"});
    }
}

