/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopStreamingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.hid.HIDService;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.VideoMediaFormat;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.inputevt.InputEvtAction;
import org.jitsi.xmpp.extensions.inputevt.InputEvtIQ;
import org.jitsi.xmpp.extensions.inputevt.RemoteControlExtension;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OperationSetDesktopSharingServerJabberImpl
extends OperationSetDesktopStreamingJabberImpl
implements OperationSetDesktopSharingServer,
RegistrationStateChangeListener,
IQRequestHandler {
    private static final Logger logger = Logger.getLogger(OperationSetDesktopSharingServerJabberImpl.class);
    private final CallPeerListener callPeerListener = new CallPeerAdapter(){

        public void peerStateChanged(CallPeerChangeEvent evt) {
            CallPeer peer = evt.getSourceCallPeer();
            CallPeerState state = peer.getState();
            if (state != null && (state.equals(CallPeerState.DISCONNECTED) || state.equals(CallPeerState.FAILED))) {
                OperationSetDesktopSharingServerJabberImpl.this.disableRemoteControl(peer);
            }
        }
    };
    private HIDService hidService = null;
    private final List<Jid> callPeers = new ArrayList<Jid>();

    public OperationSetDesktopSharingServerJabberImpl(OperationSetBasicTelephonyJabberImpl basicTelephony) {
        super(basicTelephony);
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).addRegistrationStateChangeListener(this);
        this.hidService = JabberActivator.getHIDService();
    }

    @Override
    public Call createVideoCall(String uri, MediaDevice device) throws OperationFailedException, ParseException {
        MediaAwareCall call = (MediaAwareCall)super.createVideoCall(uri, device);
        this.size = ((VideoMediaFormat)call.getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
        this.origin = OperationSetDesktopSharingServerJabberImpl.getOriginForMediaDevice(device);
        return call;
    }

    @Override
    public Call createVideoCall(Contact callee, MediaDevice device) throws OperationFailedException {
        MediaAwareCall call = (MediaAwareCall)super.createVideoCall(callee, device);
        this.size = ((VideoMediaFormat)call.getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
        this.origin = OperationSetDesktopSharingServerJabberImpl.getOriginForMediaDevice(device);
        return call;
    }

    @Override
    protected Call createOutgoingVideoCall(String calleeAddress) throws OperationFailedException {
        return this.createOutgoingVideoCall(calleeAddress, null);
    }

    @Override
    protected Call createOutgoingVideoCall(String calleeAddress, MediaDevice videoDevice) throws OperationFailedException {
        EntityFullJid fullCalleeURI;
        Jid calleeJid;
        boolean remoteControlSupported = false;
        try {
            calleeJid = JidCreate.from((String)calleeAddress);
        }
        catch (XmppStringprepException e) {
            throw new OperationFailedException(calleeAddress + "is not a valid JID", 1, (Throwable)e);
        }
        if (calleeJid.hasResource()) {
            fullCalleeURI = calleeJid.asFullJidOrThrow();
        } else {
            Roster r = Roster.getInstanceFor((XMPPConnection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
            fullCalleeURI = r.getPresence(calleeJid.asBareJid()).getFrom().asFullJidOrThrow();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"creating outgoing desktop sharing call...");
        }
        DiscoverInfo di = null;
        try {
            di = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getDiscoveryManager().discoverInfo((Jid)fullCalleeURI);
            if (di.containsFeature((CharSequence)"http://jitsi.org/protocol/inputevt/sharee")) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(fullCalleeURI + ": remote-control supported"));
                }
                remoteControlSupported = true;
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)(fullCalleeURI + ": remote-control not supported!"));
            }
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
            logger.warn((Object)("could not retrieve info for " + fullCalleeURI), ex);
        }
        if (((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection() == null) {
            throw new OperationFailedException("Failed to create OutgoingJingleSession.\nwe don't have a valid XMPPConnection.", 4);
        }
        CallJabberImpl call = new CallJabberImpl((OperationSetBasicTelephonyJabberImpl)this.basicTelephony);
        MediaUseCase useCase = this.getMediaUseCase();
        if (videoDevice != null) {
            call.setVideoDevice(videoDevice, useCase);
            call.setLocalVideoAllowed(true, useCase);
            call.setLocalInputEvtAware(remoteControlSupported);
            this.size = ((VideoMediaFormat)videoDevice.getFormat()).getSize();
        }
        ((OperationSetBasicTelephonyJabberImpl)this.basicTelephony).createOutgoingCall(call, calleeAddress);
        new CallPeerJabberImpl(calleeJid, call);
        return call;
    }

    @Override
    public void setLocalVideoAllowed(Call call, MediaDevice mediaDevice, boolean allowed) throws OperationFailedException {
        ((CallJabberImpl)call).setLocalInputEvtAware(allowed);
        super.setLocalVideoAllowed(call, mediaDevice, allowed);
    }

    public void enableRemoteControl(CallPeer callPeer) {
        callPeer.addCallPeerListener(this.callPeerListener);
        this.size = ((VideoMediaFormat)((CallJabberImpl)callPeer.getCall()).getDefaultDevice(MediaType.VIDEO).getFormat()).getSize();
        this.modifyRemoteControl(callPeer, true);
    }

    public void disableRemoteControl(CallPeer callPeer) {
        this.modifyRemoteControl(callPeer, false);
        callPeer.removeCallPeerListener(this.callPeerListener);
        this.origin = null;
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        OperationSetDesktopSharingServerJabberImpl.registrationStateChanged(evt, this, ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
    }

    public static void registrationStateChanged(RegistrationStateChangeEvent evt, IQRequestHandler packetListener, XMPPConnection connection) {
        if (connection == null) {
            return;
        }
        if (evt.getNewState() == RegistrationState.REGISTERING) {
            connection.registerIQRequestHandler(packetListener);
        } else if (evt.getNewState() == RegistrationState.UNREGISTERING) {
            connection.unregisterIQRequestHandler(packetListener);
        }
    }

    public void processComponentEvent(ComponentEvent event) {
        if (event == null) {
            return;
        }
        if (event instanceof KeyEvent) {
            this.processKeyboardEvent((KeyEvent)event);
        } else if (event instanceof MouseEvent) {
            this.processMouseEvent((MouseEvent)event);
        }
    }

    public void processKeyboardEvent(KeyEvent event) {
        if (this.hidService != null) {
            int keycode = 0;
            if (event.getKeyChar() != '\u0000' && event.getID() == 400) {
                this.hidService.keyPress(event.getKeyChar());
                this.hidService.keyRelease(event.getKeyChar());
                return;
            }
            keycode = event.getKeyCode();
            if (keycode == 0) {
                return;
            }
            switch (event.getID()) {
                case 401: {
                    this.hidService.keyPress(keycode);
                    break;
                }
                case 402: {
                    this.hidService.keyRelease(keycode);
                    break;
                }
            }
        }
    }

    public void processMouseEvent(MouseEvent event) {
        if (this.hidService != null) {
            switch (event.getID()) {
                case 501: {
                    this.hidService.mousePress(event.getModifiers());
                    break;
                }
                case 502: {
                    this.hidService.mouseRelease(event.getModifiers());
                    break;
                }
                case 503: {
                    int originX = this.origin != null ? this.origin.x : 0;
                    int originY = this.origin != null ? this.origin.y : 0;
                    int x = originX + event.getX() * this.size.width / 1000;
                    int y = originY + event.getY() * this.size.height / 1000;
                    this.hidService.mouseMove(x, y);
                    break;
                }
                case 507: {
                    MouseWheelEvent evt = (MouseWheelEvent)event;
                    this.hidService.mouseWheel(evt.getWheelRotation());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRemoteControl(CallPeer cp, boolean enables) {
        CallPeerJabberImpl callPeer = (CallPeerJabberImpl)cp;
        List<Jid> list = this.callPeers;
        synchronized (list) {
            if (this.callPeers.contains(callPeer.getAddressAsJid()) != enables && this.isRemoteControlAvailable((CallPeer)callPeer)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Enables remote control: " + enables));
                }
                InputEvtIQ inputIQ = new InputEvtIQ();
                if (enables) {
                    inputIQ.setAction(InputEvtAction.START);
                } else {
                    inputIQ.setAction(InputEvtAction.STOP);
                }
                inputIQ.setType(IQ.Type.set);
                inputIQ.setFrom(((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID());
                inputIQ.setTo(callPeer.getAddressAsJid());
                Stanza p = null;
                try {
                    StanzaCollector collector = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().createStanzaCollectorAndSend((IQ)inputIQ);
                    try {
                        p = collector.nextResult();
                    }
                    finally {
                        collector.cancel();
                    }
                }
                catch (InterruptedException | SmackException.NotConnectedException e) {
                    logger.error((Object)"Could not set remote control status", e);
                }
                if (enables) {
                    this.receivedResponseToIqStart(callPeer, p);
                } else {
                    this.receivedResponseToIqStop(callPeer, p);
                }
            }
        }
    }

    private void receivedResponseToIqStart(CallPeerJabberImpl callPeer, Stanza p) {
        if (p != null && ((IQ)p).getType() == IQ.Type.result) {
            this.callPeers.add(callPeer.getAddressAsJid());
        } else {
            String packetString = p == null ? "\n\tPacket is null (IQ request timeout)." : "\n\tPacket: " + p.toXML();
            logger.info((Object)("Remote peer has not received/accepted the START action to grant the remote desktop control." + packetString));
        }
    }

    private void receivedResponseToIqStop(CallPeerJabberImpl callPeer, Stanza p) {
        if (p == null || ((IQ)p).getType() == IQ.Type.error) {
            String packetString = p == null ? "\n\tPacket is null (IQ request timeout)." : "\n\tPacket: " + p.toXML();
            logger.info((Object)("Remote peer has not received/accepted the STOP action to grant the remote desktop control." + packetString));
        }
        this.callPeers.remove(callPeer.getAddressAsJid());
    }

    public boolean isRemoteControlAvailable(CallPeer callPeer) {
        DiscoverInfo discoverInfo = ((CallPeerJabberImpl)callPeer).getDiscoveryInfo();
        return ((ProtocolProviderServiceJabberImpl)this.parentProvider).getDiscoveryManager().includesFeature("http://jitsi.org/protocol/inputevt/sharer") && discoverInfo != null && discoverInfo.containsFeature((CharSequence)"http://jitsi.org/protocol/inputevt/sharee");
    }

    public IQ handleIQRequest(IQ iqRequest) {
        InputEvtIQ inputIQ = (InputEvtIQ)iqRequest;
        if (inputIQ.getAction() == InputEvtAction.NOTIFY && this.callPeers.contains(inputIQ.getFrom())) {
            for (RemoteControlExtension p : inputIQ.getRemoteControls()) {
                ComponentEvent evt = p.getEvent();
                this.processComponentEvent(evt);
            }
        }
        return IQ.createResultIQ((IQ)inputIQ);
    }

    public IQRequestHandler.Mode getMode() {
        return IQRequestHandler.Mode.sync;
    }

    public IQ.Type getType() {
        return IQ.Type.set;
    }

    public String getElement() {
        return "inputevt";
    }

    public String getNamespace() {
        return "http://jitsi.org/protocol/inputevt";
    }
}

