/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicInstantMessagingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.chatstates.ChatState;
import org.jivesoftware.smackx.chatstates.packet.ChatStateExtension;
import org.jivesoftware.smackx.xevent.MessageEventManager;
import org.jivesoftware.smackx.xevent.MessageEventNotificationListener;
import org.jivesoftware.smackx.xevent.MessageEventRequestListener;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public class OperationSetTypingNotificationsJabberImpl
extends AbstractOperationSetTypingNotifications<ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetTypingNotificationsJabberImpl.class);
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private OperationSetBasicInstantMessagingJabberImpl opSetBasicIM = null;
    private ProviderRegListener providerRegListener = new ProviderRegListener();
    private MessageEventManager messageEventManager = null;
    private SmackChatStateListener smackChatStateListener = null;

    OperationSetTypingNotificationsJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        super((ProtocolProviderService)provider);
        provider.addRegistrationStateChangeListener(this.providerRegListener);
    }

    public void sendTypingNotification(Contact notifiedContact, int typingState) throws IllegalStateException, IllegalArgumentException {
        this.assertConnected();
        if (!(notifiedContact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not a Jabber contact." + notifiedContact);
        }
        try {
            this.sendXep85ChatState((ContactJabberImpl)notifiedContact, typingState);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new IllegalStateException("Failed to send typing notification", e);
        }
    }

    private void sendXep85ChatState(ContactJabberImpl contact, int state) throws SmackException.NotConnectedException, InterruptedException {
        if (this.opSetBasicIM == null || ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection() == null) {
            return;
        }
        Jid toJID = this.opSetBasicIM.getRecentJIDForAddress(contact.getAddressAsJid().asBareJid());
        if (toJID == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Sending XEP-0085 chat state=" + state + " to " + toJID));
        }
        ChatState chatState = state == 1 ? ChatState.composing : (state == 4 ? ChatState.inactive : (state == 3 ? ChatState.paused : ChatState.gone));
        this.setCurrentState(chatState, toJID);
    }

    private void setCurrentState(ChatState chatState, Jid jid) throws SmackException.NotConnectedException, InterruptedException {
        String threadID = this.opSetBasicIM.getThreadIDForAddress(jid.asBareJid());
        if (threadID == null) {
            return;
        }
        Message message = new Message();
        ChatStateExtension extension = new ChatStateExtension(chatState);
        message.addExtension((ExtensionElement)extension);
        message.setTo(jid);
        message.setType(Message.Type.chat);
        message.setThread(threadID);
        message.setFrom((Jid)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().getUser());
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendStanza((Stanza)message);
    }

    protected void assertConnected() throws IllegalStateException {
        if (this.parentProvider != null && !((ProtocolProviderServiceJabberImpl)this.parentProvider).isRegistered() && this.opSetPersPresence.getPresenceStatus().isOnline()) {
            this.opSetPersPresence.fireProviderStatusChangeEvent(this.opSetPersPresence.getPresenceStatus(), (PresenceStatus)((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline"));
        }
        super.assertConnected();
    }

    private class SmackChatStateListener
    implements StanzaListener {
        private SmackChatStateListener() {
        }

        public void stateChanged(ChatState state, Message message) {
            Object sourceContact;
            Jid fromJID = message.getFrom();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(fromJID + " entered the " + state.name() + " state."));
            }
            BareJid fromID = fromJID.asBareJid();
            boolean isPrivateMessagingAddress = false;
            OperationSetMultiUserChat mucOpSet = (OperationSetMultiUserChat)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetMultiUserChat.class);
            if (mucOpSet != null) {
                List chatRooms = mucOpSet.getCurrentlyJoinedChatRooms();
                for (ChatRoom chatRoom : chatRooms) {
                    if (!chatRoom.getName().equals(fromID.toString())) continue;
                    isPrivateMessagingAddress = true;
                    break;
                }
            }
            if ((sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID((Jid)(isPrivateMessagingAddress ? message.getFrom() : fromID))) == null) {
                if (message.getError() != null) {
                    sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID(message.getFrom());
                }
                if (sourceContact == null) {
                    sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(message.getFrom(), isPrivateMessagingAddress);
                }
            }
            int evtCode = 0;
            if (ChatState.composing.equals((Object)state)) {
                evtCode = 1;
            } else if (ChatState.paused.equals((Object)state) || ChatState.active.equals((Object)state)) {
                evtCode = 3;
            } else if (ChatState.inactive.equals((Object)state) || ChatState.gone.equals((Object)state)) {
                evtCode = 4;
            }
            if (message.getError() != null) {
                OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsDeliveryFailedEvent((Contact)sourceContact, evtCode);
            } else if (evtCode != 0) {
                OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, evtCode);
            } else {
                logger.warn((Object)"Unknown typing state!");
            }
        }

        public void processStanza(Stanza packet) {
            Message msg = (Message)packet;
            ChatStateExtension ext = (ChatStateExtension)msg.getExtension("http://jabber.org/protocol/chatstates");
            if (ext == null) {
                return;
            }
            this.stateChanged(ChatState.valueOf((String)ext.getElementName()), msg);
        }
    }

    private class IncomingMessageEventsListener
    implements MessageEventNotificationListener {
        private IncomingMessageEventsListener() {
        }

        public void deliveredNotification(Jid from, String packetID) {
        }

        public void displayedNotification(Jid from, String packetID) {
        }

        public void composingNotification(Jid from, String packetID) {
            Object sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID((Jid)from.asBareJid());
            if (sourceContact == null) {
                sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(from);
            }
            OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, 1);
        }

        public void offlineNotification(Jid from, String packetID) {
        }

        public void cancelledNotification(Jid from, String packetID) {
            Object sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID((Jid)from.asBareJid());
            if (sourceContact == null) {
                sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(from);
            }
            OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, 4);
        }
    }

    private class JabberMessageEventRequestListener
    implements MessageEventRequestListener {
        private JabberMessageEventRequestListener() {
        }

        public void deliveredNotificationRequested(Jid from, String packetID, MessageEventManager messageEventManager) throws SmackException.NotConnectedException, InterruptedException {
            messageEventManager.sendDeliveredNotification(from, packetID);
        }

        public void displayedNotificationRequested(Jid from, String packetID, MessageEventManager messageEventManager) {
            try {
                messageEventManager.sendDisplayedNotification(from, packetID);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                logger.error((Object)"Could not send displayed notification", e);
            }
        }

        public void composingNotificationRequested(Jid from, String packetID, MessageEventManager messageEventManager) {
        }

        public void offlineNotificationRequested(Jid from, String packetID, MessageEventManager messageEventManager) {
        }
    }

    private class ProviderRegListener
    implements RegistrationStateChangeListener {
        private ProviderRegListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetPersistentPresence.class);
                OperationSetTypingNotificationsJabberImpl.this.opSetBasicIM = (OperationSetBasicInstantMessagingJabberImpl)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetBasicInstantMessaging.class);
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager = MessageEventManager.getInstanceFor((XMPPConnection)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection());
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager.addMessageEventRequestListener((MessageEventRequestListener)new JabberMessageEventRequestListener());
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager.addMessageEventNotificationListener((MessageEventNotificationListener)new IncomingMessageEventsListener());
                if (OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener == null) {
                    OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener = new SmackChatStateListener();
                }
                ((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection().addAsyncStanzaListener((StanzaListener)OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener, (StanzaFilter)new StanzaTypeFilter(Message.class));
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                if (((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection() != null) {
                    ((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection().removeAsyncStanzaListener((StanzaListener)OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener);
                }
                OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener = null;
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager = null;
            }
        }
    }
}

