/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.caps;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.Jid;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class CapsConfigurationPersistence
implements EntityCapsPersistentCache {
    private static final Logger logger = Logger.getLogger(CapsConfigurationPersistence.class);
    private ConfigurationService configService;
    private static final String CAPS_PROPERTY_NAME_PREFIX = "net.java.sip.communicator.impl.protocol.jabber.extensions.caps.EntityCapsManager.CAPS.";

    public CapsConfigurationPersistence(ConfigurationService configService) {
        this.configService = configService;
    }

    public void addDiscoverInfoByNodePersistent(String nodeVer, DiscoverInfo info) {
        CapsConfigurationPersistence.cleanupDiscoverInfo(info);
        info.setNode(nodeVer);
        String xml = info.getChildElementXML().toString();
        if (xml != null && xml.length() != 0) {
            this.configService.setProperty(CAPS_PROPERTY_NAME_PREFIX + nodeVer, (Object)xml);
        }
    }

    private static void cleanupDiscoverInfo(DiscoverInfo info) {
        info.setFrom((Jid)null);
        info.setTo((Jid)null);
        info.setStanzaId(null);
    }

    public DiscoverInfo lookup(String nodeVer) {
        IQProvider discoverInfoProvider;
        DiscoverInfo discoverInfo = null;
        String capsPropertyName = CAPS_PROPERTY_NAME_PREFIX + nodeVer;
        String xml = this.configService.getString(capsPropertyName);
        if (xml != null && xml.length() != 0 && (discoverInfoProvider = ProviderManager.getIQProvider((String)"query", (String)"http://jabber.org/protocol/disco#info")) != null) {
            MXParser parser = new MXParser();
            try {
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                parser.setInput((Reader)new StringReader(xml));
                parser.next();
            }
            catch (XmlPullParserException xppex) {
                parser = null;
            }
            catch (IOException ioex) {
                parser = null;
            }
            if (parser != null) {
                try {
                    discoverInfo = (DiscoverInfo)discoverInfoProvider.parse((XmlPullParser)parser);
                }
                catch (Exception ex) {
                    logger.error((Object)("Invalid DiscoverInfo for " + nodeVer + ": " + discoverInfo));
                    this.configService.removeProperty(capsPropertyName);
                }
            }
        }
        return discoverInfo;
    }

    public void emptyCache() {
    }
}

