/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.component;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.util.IQUtils;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jivesoftware.smackx.ping.provider.PingProvider;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmpp.component.AbstractComponent;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Packet;

public abstract class ComponentBase
extends AbstractComponent {
    private static final Logger logger = Logger.getLogger(ComponentBase.class);
    public static final long DEFAULT_PROCESSING_TIME_LIMIT = 100L;
    public static final String PING_INTERVAL_PNAME = "PING_INTERVAL";
    public static final String PING_TIMEOUT_PNAME = "PING_TIMEOUT";
    public static final String PING_THRESHOLD_PNAME = "PING_THRESHOLD";
    public static final String PROCESSING_TIME_LIMIT_PNAME = "PROCESSING_TIME_LIMIT";
    private final String hostname;
    private final int port;
    private final String domain;
    private final String subdomain;
    private final String secret;
    private long pingInterval = -1L;
    private long pingTimeout;
    private int pingThreshold;
    private final Map<String, TimeoutTask> timeouts = new HashMap<String, TimeoutTask>();
    private int pingFailures = 0;
    private Timer pingTimer;
    private boolean started;
    private long processingTimeLimit;

    public ComponentBase(String host, int port, String domain, String subDomain, String secret) {
        super(17, 1000, true);
        this.hostname = host;
        this.port = port;
        this.domain = domain;
        this.subdomain = subDomain;
        this.secret = secret;
    }

    protected void loadConfig(ConfigurationService config, String configPropertiesBase) {
        configPropertiesBase = configPropertiesBase + ".";
        this.pingInterval = config.getLong(configPropertiesBase + PING_INTERVAL_PNAME, 10000L);
        this.pingTimeout = config.getLong(configPropertiesBase + PING_TIMEOUT_PNAME, 5000L);
        this.pingThreshold = config.getInt(configPropertiesBase + PING_THRESHOLD_PNAME, 3);
        this.processingTimeLimit = config.getLong(configPropertiesBase + PROCESSING_TIME_LIMIT_PNAME, 100L);
        logger.info((Object)("Component " + configPropertiesBase + " config: "));
        logger.info((Object)("  ping interval: " + this.pingInterval + " ms"));
        logger.info((Object)("  ping timeout: " + this.pingTimeout + " ms"));
        logger.info((Object)("  ping threshold: " + this.pingThreshold));
    }

    public void init() {
    }

    public void dispose() {
    }

    public void postComponentStart() {
        super.postComponentStart();
        this.started = true;
        this.startPingTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPingTask() {
        Map<String, TimeoutTask> map = this.timeouts;
        synchronized (map) {
            if (this.pingInterval > 0L) {
                ProviderManager.addIQProvider((String)"ping", (String)"urn:xmpp:ping", (Object)new PingProvider());
                this.pingTimer = new Timer();
                this.pingTimer.schedule((TimerTask)new PingTask(), this.pingInterval, this.pingInterval);
            }
        }
    }

    protected boolean isPingTaskStarted() {
        return this.pingTimer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preComponentShutdown() {
        this.started = false;
        super.preComponentShutdown();
        Map<String, TimeoutTask> map = this.timeouts;
        synchronized (map) {
            if (this.pingTimer != null) {
                this.pingTimer.cancel();
                this.pingTimer = null;
            }
            this.timeouts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionAlive() {
        if (!this.started) {
            return false;
        }
        Map<String, TimeoutTask> map = this.timeouts;
        synchronized (map) {
            return this.pingFailures < this.pingThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IQ handleIQGet(IQ iq) throws Exception {
        long startTimestamp = System.currentTimeMillis();
        try {
            IQ iQ = this.handleIQGetImpl(iq);
            return iQ;
        }
        finally {
            this.verifyProcessingTime(startTimestamp, iq);
        }
    }

    protected IQ handleIQGetImpl(IQ iq) throws Exception {
        return super.handleIQGet(iq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IQ handleIQSet(IQ iq) throws Exception {
        long startTimestamp = System.currentTimeMillis();
        try {
            IQ iQ = this.handleIQSetImpl(iq);
            return iQ;
        }
        finally {
            this.verifyProcessingTime(startTimestamp, iq);
        }
    }

    protected IQ handleIQSetImpl(IQ iq) throws Exception {
        return super.handleIQSet(iq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleIQResult(IQ iq) {
        long startTimestamp = System.currentTimeMillis();
        try {
            this.handleIQResultImpl(iq);
        }
        finally {
            this.verifyProcessingTime(startTimestamp, iq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleIQResultImpl(IQ iq) {
        super.handleIQResult(iq);
        Map<String, TimeoutTask> map = this.timeouts;
        synchronized (map) {
            String packetId = iq.getID();
            TimeoutTask timeout = this.timeouts.get(packetId);
            if (timeout != null) {
                timeout.gotResult();
                this.timeouts.remove(packetId);
                this.pingFailures = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleIQError(IQ iq) {
        long startTimestamp = System.currentTimeMillis();
        try {
            this.handleIQErrorImpl(iq);
        }
        finally {
            this.verifyProcessingTime(startTimestamp, iq);
        }
    }

    protected void handleIQErrorImpl(IQ iq) {
        super.handleIQError(iq);
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public String getSecret() {
        return this.secret;
    }

    private void verifyProcessingTime(long startTimestamp, IQ iq) {
        long processingTime = System.currentTimeMillis() - startTimestamp;
        if (processingTime > this.processingTimeLimit) {
            logger.warn((Object)("PROCESSING TIME LIMIT EXCEEDED - it took " + processingTime + "ms to process: " + iq.toXML()));
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("It took " + processingTime + "ms to process packet: " + iq.getID()));
        }
    }

    private class TimeoutTask
    extends TimerTask {
        private final String packetId;
        private boolean hasResult;

        public TimeoutTask(String packetId) {
            this.packetId = packetId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gotResult() {
            Map map = ComponentBase.this.timeouts;
            synchronized (map) {
                this.hasResult = true;
                logger.debug((Object)("Got ping response for: " + this.packetId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = ComponentBase.this.timeouts;
            synchronized (map) {
                if (!this.hasResult && ComponentBase.this.timeouts.containsKey(this.packetId)) {
                    ComponentBase.this.pingFailures++;
                    logger.error((Object)("Ping timeout for ID: " + this.packetId));
                    ComponentBase.this.timeouts.remove(this.packetId);
                }
            }
        }
    }

    private class PingTask
    extends TimerTask {
        private PingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Map map = ComponentBase.this.timeouts;
                synchronized (map) {
                    if (ComponentBase.this.pingTimer == null) {
                        return;
                    }
                    String domain = ComponentBase.this.getDomain();
                    String subdomain = ComponentBase.this.getSubdomain();
                    Ping ping = new Ping((Jid)JidCreate.domainBareFrom((String)domain));
                    ping.setFrom((Jid)JidCreate.domainBareFrom((String)(subdomain + "." + domain)));
                    IQ pingIq = IQUtils.convert((org.jivesoftware.smack.packet.IQ)ping);
                    logger.debug((Object)("Sending ping IQ: " + ping.toXML()));
                    ComponentBase.this.send((Packet)pingIq);
                    String packetId = pingIq.getID();
                    TimeoutTask timeout = new TimeoutTask(packetId);
                    ComponentBase.this.timeouts.put(packetId, timeout);
                    ComponentBase.this.pingTimer.schedule((TimerTask)timeout, ComponentBase.this.pingTimeout);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to send ping", (Throwable)e);
                ComponentBase.this.pingFailures++;
            }
        }
    }
}

