/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.mucclient;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.jitsi.utils.concurrent.ExecutorUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.mucclient.IQListener;
import org.jitsi.xmpp.mucclient.MucClient;
import org.jitsi.xmpp.mucclient.MucClientConfiguration;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.util.XmppStringUtils;

public class MucClientManager {
    private static final Logger logger = Logger.getLogger(MucClientManager.class);
    private final Map<String, MucClient> mucClients = new ConcurrentHashMap<String, MucClient>();
    private final Set<String> features = new HashSet<String>();
    private IQListener iqListener;
    private List<IQ> registeredIqs = new LinkedList<IQ>();
    private final Map<String, ExtensionElement> presenceExtensions = new ConcurrentHashMap<String, ExtensionElement>();
    private final Object syncRoot = new Object();
    private final Executor executor;

    public MucClientManager() {
        this(new String[0]);
    }

    public MucClientManager(String[] features) {
        this(features, ExecutorUtils.newCachedThreadPool((boolean)true, (String)MucClientManager.class.getSimpleName()));
    }

    public MucClientManager(String[] features, Executor executor) {
        SmackConfiguration.setUnknownIqRequestReplyMode((SmackConfiguration.UnknownIqRequestReplyMode)SmackConfiguration.UnknownIqRequestReplyMode.replyFeatureNotImplemented);
        this.executor = executor;
        if (features != null) {
            this.features.addAll(Arrays.asList(features));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMucClient(MucClientConfiguration config) {
        MucClient mucClient;
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.mucClients.get(config.getId()) != null) {
                logger.error((Object)"Not adding a new MUC client, ID already exists.");
                return false;
            }
            mucClient = new MucClient(config, this);
            this.mucClients.put(config.getId(), mucClient);
        }
        this.executor.execute(() -> {
            try {
                mucClient.initializeConnectAndJoin();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to initialize and start a MucClient: ", (Throwable)e);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPresenceExtension(ExtensionElement extension) {
        Object object = this.syncRoot;
        synchronized (object) {
            logger.info((Object)("Setting a presence extension: " + extension));
            this.saveExtension(extension);
            this.mucClients.values().forEach(mucClient -> mucClient.setPresenceExtension(extension));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveExtension(ExtensionElement extension) {
        Object object = this.syncRoot;
        synchronized (object) {
            ExtensionElement previousExtension = this.presenceExtensions.put(XmppStringUtils.generateKey((String)extension.getElementName(), (String)extension.getNamespace()), extension);
            if (previousExtension != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Replacing presence extension: " + previousExtension));
            }
        }
    }

    private void removeExtension(String elementName, String namespace) {
        this.presenceExtensions.remove(XmppStringUtils.generateKey((String)elementName, (String)namespace));
    }

    Collection<ExtensionElement> getPresenceExtensions() {
        return this.presenceExtensions.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePresenceExtension(String elementName, String namespace) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.removeExtension(elementName, namespace);
            this.mucClients.values().forEach(mucClient -> mucClient.removePresenceExtension(elementName, namespace));
        }
    }

    Set<String> getFeatures() {
        return this.features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIQListener(IQListener iqListener) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.iqListener != null) {
                logger.info((Object)"Replacing an existing IQ listener.");
            }
            this.iqListener = iqListener;
            this.mucClients.values().forEach(m -> m.setIQListener(iqListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIQ(IQ iq) {
        Object object = this.syncRoot;
        synchronized (object) {
            this.registeredIqs.add(iq);
            this.mucClients.values().forEach(mucClient -> mucClient.registerIQ(iq));
        }
    }

    public void registerIQ(String elementName, String namespace) {
        this.registerIQ(new IQ(elementName, namespace){

            protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
                return null;
            }
        });
    }

    List<IQ> getRegisteredIqs() {
        return new LinkedList<IQ>(this.registeredIqs);
    }

    IQListener getIqListener() {
        return this.iqListener;
    }

    public boolean removeMucClient(String id) {
        MucClient mucClient = this.mucClients.remove(id);
        if (mucClient == null) {
            logger.info((Object)"Can not find MucClient to remove.");
            return false;
        }
        mucClient.stop();
        return true;
    }
}

