/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import net.sf.fmj.utility.LoggerSingleton;

public class PlugInManager {
    private static final Logger logger = LoggerSingleton.logger;
    public static final int DEMULTIPLEXER = 1;
    public static final int CODEC = 2;
    public static final int EFFECT = 3;
    public static final int RENDERER = 4;
    public static final int MULTIPLEXER = 5;
    private static Class<?> implClass;
    private static Method getPlugInListMethod;
    private static Method setPlugInListMethod;
    private static Method commitMethod;
    private static Method addPlugInMethod;
    private static Method removePlugInMethod;
    private static Method getSupportedInputFormatsMethod;
    private static Method getSupportedOutputFormatsMethod;

    public static boolean addPlugIn(String classname, Format[] in, Format[] out, int type) {
        if (!PlugInManager.init()) {
            return false;
        }
        return (Boolean)PlugInManager.callImpl(addPlugInMethod, new Object[]{classname, in, out, type});
    }

    private static Object callImpl(Method method, Object[] args) {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
    }

    public static void commit() throws IOException {
        if (!PlugInManager.init()) {
            return;
        }
        PlugInManager.callImpl(commitMethod, new Object[0]);
    }

    public static Vector getPlugInList(Format input, Format output, int type) {
        if (!PlugInManager.init()) {
            return null;
        }
        return (Vector)PlugInManager.callImpl(getPlugInListMethod, new Object[]{input, output, type});
    }

    private static Method getStaticMethodOnImplClass(String name, Class<?>[] args, Class<?> returnType) throws Exception {
        Method m = implClass.getMethod(name, args);
        if (m.getReturnType() != returnType) {
            throw new Exception("Expected return type of method " + name + " to be " + returnType + ", was " + m.getReturnType());
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new Exception("Expected method " + name + " to be static");
        }
        return m;
    }

    public static Format[] getSupportedInputFormats(String className, int type) {
        if (!PlugInManager.init()) {
            return null;
        }
        return (Format[])PlugInManager.callImpl(getSupportedInputFormatsMethod, new Object[]{className, type});
    }

    public static Format[] getSupportedOutputFormats(String className, int type) {
        if (!PlugInManager.init()) {
            return null;
        }
        return (Format[])PlugInManager.callImpl(getSupportedOutputFormatsMethod, new Object[]{className, type});
    }

    private static synchronized boolean init() {
        if (implClass != null) {
            return true;
        }
        try {
            implClass = Class.forName("javax.media.pim.PlugInManager");
            if (!PlugInManager.class.isAssignableFrom(implClass)) {
                throw new Exception("javax.media.pim.PlugInManager not subclass of " + PlugInManager.class.getName());
            }
            getPlugInListMethod = PlugInManager.getStaticMethodOnImplClass("getPlugInList", new Class[]{Format.class, Format.class, Integer.TYPE}, Vector.class);
            setPlugInListMethod = PlugInManager.getStaticMethodOnImplClass("setPlugInList", new Class[]{Vector.class, Integer.TYPE}, Void.TYPE);
            commitMethod = PlugInManager.getStaticMethodOnImplClass("commit", new Class[0], Void.TYPE);
            addPlugInMethod = PlugInManager.getStaticMethodOnImplClass("addPlugIn", new Class[]{String.class, Format[].class, Format[].class, Integer.TYPE}, Boolean.TYPE);
            removePlugInMethod = PlugInManager.getStaticMethodOnImplClass("removePlugIn", new Class[]{String.class, Integer.TYPE}, Boolean.TYPE);
            getSupportedInputFormatsMethod = PlugInManager.getStaticMethodOnImplClass("getSupportedInputFormats", new Class[]{String.class, Integer.TYPE}, Format[].class);
            getSupportedOutputFormatsMethod = PlugInManager.getStaticMethodOnImplClass("getSupportedOutputFormats", new Class[]{String.class, Integer.TYPE}, Format[].class);
        }
        catch (Throwable e) {
            implClass = null;
            logger.log(Level.SEVERE, "Unable to initialize javax.media.pim.PlugInManager: " + e, e);
            return false;
        }
        return true;
    }

    public static boolean removePlugIn(String classname, int type) {
        if (!PlugInManager.init()) {
            return false;
        }
        return (Boolean)PlugInManager.callImpl(removePlugInMethod, new Object[]{classname, type});
    }

    public static void setPlugInList(Vector plugins, int type) {
        if (!PlugInManager.init()) {
            return;
        }
        PlugInManager.callImpl(setPlugInListMethod, new Object[]{plugins, type});
    }
}

