/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.sun.media.util.Registry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    public static final boolean isEnabled;
    private static int indent;
    private static Logger logger;

    public static synchronized void comment(Object str) {
        if (isEnabled && logger.isLoggable(Level.FINE)) {
            logger.fine(str != null ? str.toString() : "null");
        }
    }

    public static synchronized void info(Object str) {
        if (isEnabled && logger.isLoggable(Level.INFO)) {
            logger.info(str != null ? str.toString() : "null");
        }
    }

    public static synchronized void decrIndent() {
        --indent;
    }

    public static synchronized void dumpStack(Throwable e) {
        if (isEnabled && logger.isLoggable(Level.FINE)) {
            for (StackTraceElement s : e.getStackTrace()) {
                logger.fine(s.toString());
            }
        }
    }

    public static synchronized void error(Object str) {
        if (isEnabled && logger.isLoggable(Level.SEVERE)) {
            logger.severe(str != null ? str.toString() : "null");
        } else {
            System.err.println(str);
        }
    }

    public static int getIndent() {
        return indent;
    }

    public static synchronized void incrIndent() {
        ++indent;
    }

    public static synchronized void profile(Object str) {
        if (isEnabled && logger.isLoggable(Level.FINER)) {
            logger.finer(str != null ? str.toString() : "null");
        }
    }

    public static synchronized void setIndent(int i) {
        indent = i;
    }

    public static synchronized void warning(Object str) {
        if (isEnabled && logger.isLoggable(Level.WARNING)) {
            logger.warning(str != null ? str.toString() : "null");
        }
    }

    public static synchronized void write(Object str) {
        if (isEnabled && logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            for (int i = indent; i > 0; --i) {
                sb.append("    ");
            }
            sb.append(str != null ? str.toString() : "null");
            logger.fine(sb.toString());
        }
    }

    private static synchronized void writeHeader() {
        Log.write("#\n# FMJ\n#\n");
        String os = null;
        String osver = null;
        String osarch = null;
        String java = null;
        String jver = null;
        try {
            os = System.getProperty("os.name");
            osarch = System.getProperty("os.arch");
            osver = System.getProperty("os.version");
            java = System.getProperty("java.vendor");
            jver = System.getProperty("java.version");
        }
        catch (Throwable e) {
            return;
        }
        if (os != null) {
            Log.comment("Platform: " + os + ", " + osarch + ", " + osver);
        }
        if (java != null) {
            Log.comment("Java VM: " + java + ", " + jver);
        }
        Log.write("");
    }

    static {
        indent = 0;
        logger = Logger.getLogger(Log.class.getName());
        Object allowLogging = Registry.get("allowLogging");
        boolean bl = isEnabled = allowLogging != null && allowLogging instanceof Boolean ? (Boolean)allowLogging : false;
        if (isEnabled) {
            Log.writeHeader();
        }
    }
}

