/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.gsm;

import org.rubycoder.gsm.GSMDecoder;
import org.rubycoder.gsm.InvalidGSMFrameException;

public class GSMDecoderUtil {
    private static GSMDecoder decoder = new GSMDecoder();
    private static final int GSM_BYTES = 33;
    private static final int PCM_INTS = 160;
    private static final int PCM_BYTES = 320;

    public static void gsmDecode(boolean bigEndian, byte[] data, int offset, int length, byte[] decoded) {
        for (int i = 0; i < length / 33; ++i) {
            int[] output = new int[160];
            byte[] input = new byte[33];
            System.arraycopy(data, i * 33, input, 0, 33);
            try {
                decoder.decode(input, output);
            }
            catch (InvalidGSMFrameException e) {
                e.printStackTrace();
            }
            for (int j = 0; j < 160; ++j) {
                int index = j << 1;
                if (bigEndian) {
                    decoded[index + i * 320] = (byte)((output[j] & 0xFF00) >> 8);
                    decoded[++index + i * 320] = (byte)(output[j] & 0xFF);
                    continue;
                }
                decoded[index + i * 320] = (byte)(output[j] & 0xFF);
                decoded[++index + i * 320] = (byte)((output[j] & 0xFF00) >> 8);
            }
        }
    }
}

