/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPRawSender;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class DefaultRTCPTransmitterImpl
implements RTCPTransmitter {
    RTCPRawSender sender;
    OverallStats stats = null;
    SSRCCache cache;
    int sdescounter = 0;
    SSRCInfo ssrcInfo = null;

    public DefaultRTCPTransmitterImpl(SSRCCache cache) {
        this.cache = cache;
        this.stats = cache.sm.defaultstats;
    }

    public DefaultRTCPTransmitterImpl(SSRCCache cache, int port, String address) throws UnknownHostException, IOException {
        this(cache, new RTCPRawSender(port, address));
    }

    public DefaultRTCPTransmitterImpl(SSRCCache cache, int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(cache, new RTCPRawSender(port, address, sender));
    }

    public DefaultRTCPTransmitterImpl(SSRCCache cache, RTCPRawSender sender) {
        this(cache);
        this.setSender(sender);
        this.stats = cache.sm.defaultstats;
    }

    public void bye(int ssrc, byte[] reason) {
        double delay;
        if (!this.cache.rtcpsent) {
            return;
        }
        this.cache.byestate = true;
        List<RTCPPacket> repvec = this.makereports();
        RTCPPacket[] packets = repvec.toArray(new RTCPPacket[repvec.size() + 1]);
        int[] ssrclist = new int[]{ssrc};
        RTCPBYEPacket byep = new RTCPBYEPacket(ssrclist, reason);
        packets[packets.length - 1] = byep;
        RTCPCompoundPacket cp = new RTCPCompoundPacket(packets);
        if (this.cache.aliveCount() > 50) {
            this.cache.reset(byep.length);
            delay = this.cache.calcReportInterval(this.ssrcInfo.sender, false);
        } else {
            delay = 0.0;
        }
        try {
            Thread.sleep((long)delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.transmit(cp);
        this.sdescounter = 0;
    }

    @Override
    public void bye(String reason) {
        if (this.ssrcInfo == null) {
            return;
        }
        if (reason != null) {
            this.bye(this.ssrcInfo.ssrc, reason.getBytes());
        } else {
            this.bye(this.ssrcInfo.ssrc, null);
        }
        this.ssrcInfo.setOurs(false);
        this.ssrcInfo = null;
    }

    @Override
    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    protected RTCPReportBlock[] makerecreports(long time) {
        ArrayList<RTCPReportBlock> reports = new ArrayList<RTCPReportBlock>();
        Enumeration<SSRCInfo> elements = this.cache.cache.elements();
        while (elements.hasMoreElements()) {
            SSRCInfo info = elements.nextElement();
            if (info.ours || !info.sender) continue;
            reports.add(info.makeReceiverReport(time));
        }
        return reports.toArray(new RTCPReportBlock[reports.size()]);
    }

    protected List<RTCPPacket> makereports() {
        RTCPReportBlock[] reports;
        ArrayList<RTCPPacket> packets = new ArrayList<RTCPPacket>();
        SSRCInfo ourinfo = this.ssrcInfo;
        boolean senderreport = ourinfo.sender;
        long time = System.currentTimeMillis();
        RTCPReportBlock[] firstrep = reports = this.makerecreports(time);
        if (reports.length > 31) {
            firstrep = new RTCPReportBlock[31];
            System.arraycopy(reports, 0, firstrep, 0, 31);
        }
        if (senderreport) {
            RTCPSRPacket srp = new RTCPSRPacket(ourinfo.ssrc, firstrep);
            packets.add(srp);
            long systime = ourinfo.systime == 0L ? System.currentTimeMillis() : ourinfo.systime;
            long secs = systime / 1000L;
            double msecs = (double)(systime - secs * 1000L) / 1000.0;
            srp.ntptimestamplsw = (int)(msecs * 4.294967296E9);
            srp.ntptimestampmsw = secs;
            srp.rtptimestamp = (int)ourinfo.rtptime;
            srp.packetcount = ourinfo.maxseq - ourinfo.baseseq;
            srp.octetcount = ourinfo.bytesreceived;
        } else {
            RTCPRRPacket rrp = new RTCPRRPacket(ourinfo.ssrc, firstrep);
            packets.add(rrp);
        }
        if (firstrep != reports) {
            for (int offset = 31; offset < reports.length; offset += 31) {
                if (reports.length - offset < 31) {
                    firstrep = new RTCPReportBlock[reports.length - offset];
                }
                System.arraycopy(reports, offset, firstrep, 0, firstrep.length);
                RTCPRRPacket rrp = new RTCPRRPacket(ourinfo.ssrc, firstrep);
                packets.add(rrp);
            }
        }
        RTCPSDESPacket sp = new RTCPSDESPacket(new RTCPSDES[1]);
        sp.sdes[0] = new RTCPSDES();
        sp.sdes[0].ssrc = this.ssrcInfo.ssrc;
        ArrayList<RTCPSDESItem> sdesItems = new ArrayList<RTCPSDESItem>();
        sdesItems.add(new RTCPSDESItem(1, ourinfo.sourceInfo.getCNAME()));
        if (this.sdescounter % 3 == 0) {
            String s;
            SourceDescription sd = ourinfo.name;
            if (sd != null && (s = sd.getDescription()) != null) {
                sdesItems.add(new RTCPSDESItem(2, s));
            }
            if ((sd = ourinfo.email) != null && (s = sd.getDescription()) != null) {
                sdesItems.add(new RTCPSDESItem(3, s));
            }
            if ((sd = ourinfo.phone) != null && (s = sd.getDescription()) != null) {
                sdesItems.add(new RTCPSDESItem(4, s));
            }
            if ((sd = ourinfo.loc) != null && (s = sd.getDescription()) != null) {
                sdesItems.add(new RTCPSDESItem(5, s));
            }
            if ((sd = ourinfo.tool) != null && (s = sd.getDescription()) != null) {
                sdesItems.add(new RTCPSDESItem(6, s));
            }
            if ((sd = ourinfo.note) != null && (s = sd.getDescription()) != null) {
                sdesItems.add(new RTCPSDESItem(7, s));
            }
        }
        ++this.sdescounter;
        sp.sdes[0].items = sdesItems.toArray(new RTCPSDESItem[sdesItems.size()]);
        packets.add(sp);
        return packets;
    }

    @Override
    public void report() {
        List<RTCPPacket> repvec = this.makereports();
        RTCPPacket[] packets = repvec.toArray(new RTCPPacket[repvec.size()]);
        RTCPCompoundPacket cp = new RTCPCompoundPacket(packets);
        this.transmit(cp);
    }

    public void setSender(RTCPRawSender s) {
        this.sender = s;
    }

    @Override
    public void setSSRCInfo(SSRCInfo info) {
        this.ssrcInfo = info;
    }

    @Override
    public SSRCInfo getSSRCInfo() {
        return this.ssrcInfo;
    }

    protected void transmit(RTCPCompoundPacket p) {
        try {
            this.sender.sendTo(p);
            if (this.ssrcInfo instanceof SendSSRCInfo) {
                ++((SendSSRCInfo)this.ssrcInfo).stats.total_rtcp;
                ++this.cache.sm.transstats.rtcp_sent;
            }
            this.cache.updateavgrtcpsize(p.length);
            if (this.cache.initial) {
                this.cache.initial = false;
            }
            if (!this.cache.rtcpsent) {
                this.cache.rtcpsent = true;
            }
        }
        catch (IOException e) {
            this.stats.update(6, 1);
            ++this.cache.sm.transstats.transmit_failed;
        }
    }

    @Override
    public SSRCCache getCache() {
        return this.cache;
    }

    @Override
    public RTCPRawSender getSender() {
        return this.sender;
    }
}

