/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.Iterator;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractOperationSetBasicAutoAnswer
implements OperationSetBasicAutoAnswer {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetBasicAutoAnswer.class);
    protected final ProtocolProviderService protocolProvider;
    protected boolean answerUnconditional = false;
    protected boolean answerWithVideo = false;

    public AbstractOperationSetBasicAutoAnswer(ProtocolProviderService protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    protected void load() {
        AccountID acc = this.protocolProvider.getAccountID();
        this.answerUnconditional = acc.getAccountPropertyBoolean("AUTO_ANSWER_UNCONDITIONAL", false);
        this.answerWithVideo = acc.getAccountPropertyBoolean("AUTO_ANSWER_WITH_VIDEO", false);
    }

    protected abstract void save();

    protected void clearLocal() {
        this.answerUnconditional = false;
    }

    @Override
    public void clear() {
        this.clearLocal();
        this.answerWithVideo = false;
        this.save();
    }

    public boolean autoAnswer(Call call, boolean isVideoCall) {
        if (this.answerUnconditional || this.satisfyAutoAnswerConditions(call)) {
            this.answerCall(call, isVideoCall);
            return true;
        }
        return false;
    }

    protected void answerCall(Call call, boolean isVideoCall) {
        Iterator<? extends CallPeer> peers = call.getCallPeers();
        while (peers.hasNext()) {
            new AutoAnswerThread(peers.next(), isVideoCall);
        }
    }

    protected abstract boolean satisfyAutoAnswerConditions(Call var1);

    @Override
    public void setAutoAnswerUnconditional() {
        this.clearLocal();
        this.answerUnconditional = true;
        this.save();
    }

    @Override
    public boolean isAutoAnswerUnconditionalSet() {
        return this.answerUnconditional;
    }

    @Override
    public void setAutoAnswerWithVideo(boolean answerWithVideo) {
        this.answerWithVideo = answerWithVideo;
        this.save();
    }

    @Override
    public boolean isAutoAnswerWithVideoSet() {
        return this.answerWithVideo;
    }

    private class AutoAnswerThread
    extends CallPeerAdapter
    implements Runnable {
        private CallPeer peer;
        private boolean isVideoCall;

        public AutoAnswerThread(CallPeer peer, boolean isVideoCall) {
            this.peer = peer;
            this.isVideoCall = isVideoCall;
            if (peer.getState() == CallPeerState.INCOMING_CALL) {
                new Thread(this).start();
            } else {
                peer.addCallPeerListener(this);
            }
        }

        @Override
        public void run() {
            OperationSetBasicTelephony opSetBasicTelephony = AbstractOperationSetBasicAutoAnswer.this.protocolProvider.getOperationSet(OperationSetBasicTelephony.class);
            OperationSetVideoTelephony opSetVideoTelephony = AbstractOperationSetBasicAutoAnswer.this.protocolProvider.getOperationSet(OperationSetVideoTelephony.class);
            try {
                if (this.isVideoCall && AbstractOperationSetBasicAutoAnswer.this.answerWithVideo && opSetVideoTelephony != null) {
                    opSetVideoTelephony.answerVideoCallPeer(this.peer);
                } else if (opSetBasicTelephony != null) {
                    opSetBasicTelephony.answerCallPeer(this.peer);
                }
            }
            catch (OperationFailedException e) {
                logger.error((Object)("Could not answer to : " + this.peer + " caused by the following exception: " + e));
            }
        }

        @Override
        public void peerStateChanged(CallPeerChangeEvent evt) {
            CallPeerState newState = (CallPeerState)evt.getNewValue();
            if (newState == CallPeerState.INCOMING_CALL) {
                evt.getSourceCallPeer().removeCallPeerListener(this);
                new Thread(this).start();
            } else if (newState == CallPeerState.DISCONNECTED || newState == CallPeerState.FAILED) {
                evt.getSourceCallPeer().removeCallPeerListener(this);
            }
        }
    }
}

