/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.service.protocol.AccountID;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;

public class EncodingsRegistrationUtil
implements Serializable {
    private boolean overrideEncodingSettings = false;
    private Map<String, String> encodingProperties = new HashMap<String, String>();

    public Map<String, String> getEncodingProperties() {
        return this.encodingProperties;
    }

    public void setEncodingProperties(Map<String, String> encodingProperties) {
        this.encodingProperties = encodingProperties;
    }

    public boolean isOverrideEncodings() {
        return this.overrideEncodingSettings;
    }

    public void setOverrideEncodings(boolean override) {
        this.overrideEncodingSettings = override;
    }

    public void loadAccount(AccountID accountID, MediaService mediaService) {
        String overrideEncodings = accountID.getAccountPropertyString("OVERRIDE_ENCODINGS");
        boolean isOverrideEncodings = Boolean.parseBoolean(overrideEncodings);
        this.setOverrideEncodings(isOverrideEncodings);
        HashMap<String, String> encodingProperties = new HashMap<String, String>();
        EncodingConfiguration encodingConfiguration = mediaService.createEmptyEncodingConfiguration();
        encodingConfiguration.loadProperties(accountID.getAccountProperties(), "Encodings");
        encodingConfiguration.storeProperties(encodingProperties, "Encodings.");
        this.setEncodingProperties(encodingProperties);
    }

    public void storeProperties(Map<String, String> propertiesMap) {
        propertiesMap.put("OVERRIDE_ENCODINGS", Boolean.toString(this.isOverrideEncodings()));
        propertiesMap.putAll(this.getEncodingProperties());
    }

    public EncodingConfiguration createEncodingConfig(MediaService mediaService) {
        EncodingConfiguration encodingConfiguration = mediaService.createEmptyEncodingConfiguration();
        encodingConfiguration.loadProperties(this.encodingProperties, "Encodings.");
        return encodingConfiguration;
    }
}

