/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public abstract class ProtocolProviderFactory {
    private static final Logger logger = Logger.getLogger(ProtocolProviderFactory.class);
    public static final String PASSWORD = "PASSWORD";
    public static final String PROTOCOL = "PROTOCOL_NAME";
    public static final String PROTOCOL_ICON_PATH = "PROTOCOL_ICON_PATH";
    public static final String ACCOUNT_ICON_PATH = "ACCOUNT_ICON_PATH";
    public static final String USER_ID = "USER_ID";
    public static final String DISPLAY_NAME = "DISPLAY_NAME";
    public static final String ACCOUNT_DISPLAY_NAME = "ACCOUNT_DISPLAY_NAME";
    public static final String ACCOUNT_UID = "ACCOUNT_UID";
    public static final String SERVER_ADDRESS = "SERVER_ADDRESS";
    public static final String SERVER_PORT = "SERVER_PORT";
    public static final String SERVER_TRANSPORT = "SERVER_TRANSPORT";
    public static final String PROXY_ADDRESS = "PROXY_ADDRESS";
    public static final String PROXY_PORT = "PROXY_PORT";
    public static final String PROXY_AUTO_CONFIG = "PROXY_AUTO_CONFIG";
    public static final String PREFERRED_CLEAR_PORT_PROPERTY_NAME = "net.java.sip.communicator.SIP_PREFERRED_CLEAR_PORT";
    public static final String PREFERRED_SECURE_PORT_PROPERTY_NAME = "net.java.sip.communicator.SIP_PREFERRED_SECURE_PORT";
    public static final String PROXY_TYPE = "PROXY_TYPE";
    public static final String PROXY_USERNAME = "PROXY_USERNAME";
    public static final String AUTHORIZATION_NAME = "AUTHORIZATION_NAME";
    public static final String PROXY_PASSWORD = "PROXY_PASSWORD";
    public static final String PROXY_TRANSPORT = "PROXY_TRANSPORT";
    public static final String FORCE_PROXY_BYPASS = "FORCE_PROXY_BYPASS";
    public static final String MUST_REGISTER_TO_CALL = "MUST_REGISTER_TO_CALL";
    public static final String PREFERRED_TRANSPORT = "PREFERRED_TRANSPORT";
    public static final String AUTO_GENERATE_RESOURCE = "AUTO_GENERATE_RESOURCE";
    public static final String RESOURCE = "RESOURCE";
    public static final String RESOURCE_PRIORITY = "RESOURCE_PRIORITY";
    public static final String DEFAULT_ENCRYPTION = "DEFAULT_ENCRYPTION";
    public static final String ENCRYPTION_PROTOCOL = "ENCRYPTION_PROTOCOL";
    public static final String ENCRYPTION_PROTOCOL_STATUS = "ENCRYPTION_PROTOCOL_STATUS";
    public static final String DEFAULT_SIPZRTP_ATTRIBUTE = "DEFAULT_SIPZRTP_ATTRIBUTE";
    public static final String CLIENT_TLS_CERTIFICATE = "CLIENT_TLS_CERTIFICATE";
    public static final String AUTO_CHANGE_USER_NAME = "AUTO_CHANGE_USER_NAME";
    public static final String NO_PASSWORD_REQUIRED = "NO_PASSWORD_REQUIRED";
    public static final String IS_PRESENCE_ENABLED = "IS_PRESENCE_ENABLED";
    public static final String FORCE_P2P_MODE = "FORCE_P2P_MODE";
    public static final String POLLING_PERIOD = "POLLING_PERIOD";
    public static final String SUBSCRIPTION_EXPIRATION = "SUBSCRIPTION_EXPIRATION";
    public static final String SERVER_ADDRESS_VALIDATED = "SERVER_ADDRESS_VALIDATED";
    public static final String IS_SERVER_OVERRIDDEN = "IS_SERVER_OVERRIDDEN";
    public static final String PROXY_ADDRESS_VALIDATED = "PROXY_ADDRESS_VALIDATED";
    public static final String STRATEGY = "STRATEGY";
    public static final String IS_PROTOCOL_HIDDEN = "IS_PROTOCOL_HIDDEN";
    public static final String IS_PREFERRED_PROTOCOL = "IS_PREFERRED_PROTOCOL";
    public static final String IS_ACCOUNT_DISABLED = "IS_ACCOUNT_DISABLED";
    public static final String IS_ACCOUNT_CONFIG_HIDDEN = "IS_CONFIG_HIDDEN";
    public static final String IS_ACCOUNT_STATUS_MENU_HIDDEN = "IS_STATUS_MENU_HIDDEN";
    public static final String IS_ACCOUNT_READ_ONLY = "IS_READ_ONLY";
    public static final String ACCOUNT_READ_ONLY_GROUPS = "READ_ONLY_GROUPS";
    public static final String IS_USE_ICE = "ICE_ENABLED";
    public static final String AUTO_DISCOVER_STUN = "AUTO_DISCOVER_STUN";
    public static final String USE_DEFAULT_STUN_SERVER = "USE_DEFAULT_STUN_SERVER";
    public static final String USE_JITSI_VIDEO_BRIDGE = "USE_JITSI_VIDEO_BRIDGE";
    public static final String USE_TRANSLATOR_IN_CONFERENCE = "USE_TRANSLATOR_IN_CONFERENCE";
    public static final String STUN_PREFIX = "STUN";
    public static final String STUN_ADDRESS = "ADDRESS";
    public static final String STUN_PORT = "PORT";
    public static final String STUN_USERNAME = "USERNAME";
    public static final String STUN_PASSWORD = "PASSWORD";
    public static final String STUN_IS_TURN_SUPPORTED = "IS_TURN_SUPPORTED";
    public static final String IS_USE_JINGLE_NODES = "JINGLE_NODES_ENABLED";
    public static final String AUTO_DISCOVER_JINGLE_NODES = "AUTO_DISCOVER_JINGLE_NODES";
    public static final String JINGLE_NODES_SEARCH_BUDDIES = "JINGLE_NODES_SEARCH_BUDDIES";
    public static final String IS_USE_UPNP = "UPNP_ENABLED";
    public static final String IS_ALLOW_NON_SECURE = "ALLOW_NON_SECURE";
    public static final String VOICEMAIL_ENABLED = "VOICEMAIL_ENABLED";
    public static final String VOICEMAIL_URI = "VOICEMAIL_URI";
    public static final String VOICEMAIL_CHECK_URI = "VOICEMAIL_CHECK_URI";
    public static final String IS_CALLING_DISABLED_FOR_ACCOUNT = "CALLING_DISABLED";
    public static final String IS_VIDEO_CALLING_DISABLED_FOR_ACCOUNT = "VIDEO_CALLING_DISABLED";
    public static final String IS_DESKTOP_STREAMING_DISABLED = "DESKTOP_STREAMING_DISABLED";
    public static final String IS_DESKTOP_REMOTE_CONTROL_DISABLED = "DESKTOP_REMOTE_CONTROL_DISABLED";
    public static final String SMS_SERVER_ADDRESS = "SMS_SERVER_ADDRESS";
    public static final String KEEP_ALIVE_METHOD = "KEEP_ALIVE_METHOD";
    public static final String KEEP_ALIVE_INTERVAL = "KEEP_ALIVE_INTERVAL";
    public static final String DTMF_METHOD = "DTMF_METHOD";
    public static final String DTMF_MINIMAL_TONE_DURATION = "DTMF_MINIMAL_TONE_DURATION";
    public static final String MODE_PARANOIA = "MODE_PARANOIA";
    public static final String OVERRIDE_ENCODINGS = "OVERRIDE_ENCODINGS";
    public static final String ENCODING_PROP_PREFIX = "Encodings";
    public static final String CUSAX_PROVIDER_ACCOUNT_PROP = "cusax.XMPP_ACCOUNT_ID";
    private final BundleContext bundleContext;
    private final String protocolName;
    protected final Map<AccountID, ServiceRegistration<ProtocolProviderService>> registeredAccounts = new HashMap<AccountID, ServiceRegistration<ProtocolProviderService>>();
    public static final String SAVP_OPTION = "SAVP_OPTION";
    public static final int SAVP_OFF = 0;
    public static final int SAVP_MANDATORY = 1;
    public static final int SAVP_OPTIONAL = 2;
    public static final String SDES_CIPHER_SUITES = "SDES_CIPHER_SUITES";
    public static final String IS_CARBON_DISABLED = "CARBON_DISABLED";

    protected ProtocolProviderFactory(BundleContext bundleContext, String protocolName) {
        this.bundleContext = bundleContext;
        this.protocolName = protocolName;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public abstract AccountID installAccount(String var1, Map<String, String> var2) throws IllegalArgumentException, IllegalStateException, NullPointerException;

    public abstract void modifyAccount(ProtocolProviderService var1, Map<String, String> var2) throws NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AccountID> getRegisteredAccounts() {
        Map<AccountID, ServiceRegistration<ProtocolProviderService>> map = this.registeredAccounts;
        synchronized (map) {
            return new ArrayList<AccountID>(this.registeredAccounts.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<ProtocolProviderService> getProviderForAccount(AccountID accountID) {
        ServiceRegistration<ProtocolProviderService> registration;
        Map<AccountID, ServiceRegistration<ProtocolProviderService>> map = this.registeredAccounts;
        synchronized (map) {
            registration = this.registeredAccounts.get(accountID);
        }
        try {
            if (registration != null) {
                return registration.getReference();
            }
        }
        catch (IllegalStateException ise) {
            Map<AccountID, ServiceRegistration<ProtocolProviderService>> map2 = this.registeredAccounts;
            synchronized (map2) {
                this.registeredAccounts.remove(accountID);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uninstallAccount(AccountID accountID) {
        ServiceRegistration<ProtocolProviderService> registration;
        ServiceReference<ProtocolProviderService> serRef = this.getProviderForAccount(accountID);
        boolean wasAccountExisting = false;
        if (serRef != null) {
            BundleContext bundleContext = this.getBundleContext();
            ProtocolProviderService protocolProvider = (ProtocolProviderService)bundleContext.getService(serRef);
            try {
                protocolProvider.unregister();
            }
            catch (OperationFailedException ex) {
                logger.error((Object)("Failed to unregister protocol provider for account: " + accountID + " caused by: " + ex));
            }
        }
        Map<AccountID, ServiceRegistration<ProtocolProviderService>> map = this.registeredAccounts;
        synchronized (map) {
            registration = this.registeredAccounts.remove(accountID);
        }
        wasAccountExisting = this.removeStoredAccount(accountID);
        if (registration != null) {
            registration.unregister();
        }
        return wasAccountExisting;
    }

    protected void storeAccount(AccountID accountID) {
        this.storeAccount(accountID, true);
    }

    protected void storeAccount(AccountID accountID, boolean isModification) {
        if (!isModification && this.getAccountManager().getStoredAccounts().contains(accountID)) {
            throw new IllegalStateException("An account for id " + accountID.getUserID() + " was already loaded!");
        }
        try {
            this.getAccountManager().storeAccount(this, accountID);
        }
        catch (OperationFailedException ofex) {
            throw new UndeclaredThrowableException(ofex);
        }
    }

    public void storePassword(AccountID accountID, String password) throws IllegalArgumentException {
        try {
            this.storePassword(this.getBundleContext(), accountID, password);
        }
        catch (OperationFailedException ofex) {
            throw new UndeclaredThrowableException(ofex);
        }
    }

    protected void storePassword(BundleContext bundleContext, AccountID accountID, String password) throws IllegalArgumentException, OperationFailedException {
        String accountPrefix = ProtocolProviderFactory.findAccountPrefix(bundleContext, accountID, this.getFactoryImplPackageName());
        if (accountPrefix == null) {
            throw new IllegalArgumentException("No previous records found for account ID: " + accountID.getAccountUniqueID() + " in package" + this.getFactoryImplPackageName());
        }
        CredentialsStorageService credentialsStorage = (CredentialsStorageService)ServiceUtils.getService((BundleContext)bundleContext, CredentialsStorageService.class);
        if (!credentialsStorage.storePassword(accountPrefix, password)) {
            throw new OperationFailedException("CredentialsStorageService failed to storePassword", 1);
        }
        accountID.setPassword(password);
    }

    public String loadPassword(AccountID accountID) {
        return this.loadPassword(this.getBundleContext(), accountID);
    }

    protected String loadPassword(BundleContext bundleContext, AccountID accountID) {
        String accountPrefix = ProtocolProviderFactory.findAccountPrefix(bundleContext, accountID, this.getFactoryImplPackageName());
        if (accountPrefix == null) {
            return null;
        }
        CredentialsStorageService credentialsStorage = (CredentialsStorageService)ServiceUtils.getService((BundleContext)bundleContext, CredentialsStorageService.class);
        return credentialsStorage.loadPassword(accountPrefix);
    }

    public AccountID loadAccount(Map<String, String> accountProperties) {
        AccountID accountID = this.createAccount(accountProperties);
        this.loadAccount(accountID);
        return accountID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAccount(AccountID accountID) {
        String userID = accountID.getAccountPropertyString(USER_ID);
        ProtocolProviderService service = this.createService(userID, accountID);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put(PROTOCOL, this.protocolName);
        ((Dictionary)properties).put(USER_ID, userID);
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(ProtocolProviderService.class, (Object)service, properties);
        if (serviceRegistration == null) {
            return false;
        }
        Map<AccountID, ServiceRegistration<ProtocolProviderService>> map = this.registeredAccounts;
        synchronized (map) {
            this.registeredAccounts.put(accountID, (ServiceRegistration<ProtocolProviderService>)serviceRegistration);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadAccount(AccountID accountID) {
        ServiceRegistration<ProtocolProviderService> registration;
        ServiceReference<ProtocolProviderService> serRef = this.getProviderForAccount(accountID);
        if (serRef == null) {
            return false;
        }
        BundleContext bundleContext = this.getBundleContext();
        ProtocolProviderService protocolProvider = (ProtocolProviderService)bundleContext.getService(serRef);
        try {
            protocolProvider.unregister();
        }
        catch (OperationFailedException ex) {
            logger.error((Object)("Failed to unregister protocol provider for account: " + accountID + " caused by: " + ex));
        }
        Map<AccountID, ServiceRegistration<ProtocolProviderService>> map = this.registeredAccounts;
        synchronized (map) {
            registration = this.registeredAccounts.remove(accountID);
        }
        if (registration == null) {
            return false;
        }
        registration.unregister();
        return true;
    }

    public AccountID createAccount(Map<String, String> accountProperties) {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        String userID = accountProperties.get(USER_ID);
        if (userID == null) {
            throw new NullPointerException("The account properties contained no user id.");
        }
        String protocolName = this.getProtocolName();
        if (!accountProperties.containsKey(PROTOCOL)) {
            accountProperties.put(PROTOCOL, protocolName);
        }
        return this.createAccountID(userID, accountProperties);
    }

    protected abstract AccountID createAccountID(String var1, Map<String, String> var2);

    public String getProtocolName() {
        return this.protocolName;
    }

    protected abstract ProtocolProviderService createService(String var1, AccountID var2);

    protected boolean removeStoredAccount(AccountID accountID) {
        return this.getAccountManager().removeStoredAccount(this, accountID);
    }

    public static String findAccountPrefix(BundleContext bundleContext, AccountID accountID, String sourcePackageName) {
        ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class);
        ConfigurationService configurationService = (ConfigurationService)bundleContext.getService(confReference);
        List storedAccounts = configurationService.getPropertyNamesByPrefix(sourcePackageName, true);
        for (String accountRootPropertyName : storedAccounts) {
            String accountUID = configurationService.getString(accountRootPropertyName + "." + ACCOUNT_UID);
            if (!accountID.getAccountUniqueID().equals(accountUID)) continue;
            return accountRootPropertyName;
        }
        return null;
    }

    private String getFactoryImplPackageName() {
        String className = this.getClass().getName();
        return className.substring(0, className.lastIndexOf(46));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Preparing to stop all protocol providers of" + this));
        }
        Map<AccountID, ServiceRegistration<ProtocolProviderService>> map = this.registeredAccounts;
        synchronized (map) {
            for (ServiceRegistration<ProtocolProviderService> reg : this.registeredAccounts.values()) {
                this.stop(reg);
                reg.unregister();
            }
            this.registeredAccounts.clear();
        }
    }

    protected void stop(ServiceRegistration<ProtocolProviderService> registeredAccount) {
        ProtocolProviderService protocolProviderService = (ProtocolProviderService)this.getBundleContext().getService(registeredAccount.getReference());
        protocolProviderService.shutdown();
    }

    private AccountManager getAccountManager() {
        BundleContext bundleContext = this.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(AccountManager.class);
        return (AccountManager)bundleContext.getService(serviceReference);
    }

    public static ProtocolProviderFactory getProtocolProviderFactory(BundleContext bundleContext, String protocolName) {
        Collection serRefs;
        String osgiFilter = "(PROTOCOL_NAME=" + protocolName + ")";
        try {
            serRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            serRefs = null;
            logger.error((Object)ex);
        }
        if (serRefs == null || serRefs.isEmpty()) {
            return null;
        }
        return (ProtocolProviderFactory)bundleContext.getService((ServiceReference)serRefs.iterator().next());
    }
}

