/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.hoxt.packet.AbstractHttpOverXmpp;
import org.jivesoftware.smackx.hoxt.packet.HttpMethod;

public final class HttpOverXmppReq
extends AbstractHttpOverXmpp {
    public static final String ELEMENT = "req";
    private final HttpMethod method;
    private final String resource;
    private final int maxChunkSize;
    private final boolean sipub;
    private final boolean ibb;
    private final boolean jingle;

    private HttpOverXmppReq(Builder builder) {
        super(ELEMENT, builder);
        this.method = builder.method;
        this.resource = builder.resource;
        this.maxChunkSize = builder.maxChunkSize;
        this.ibb = builder.ibb;
        this.jingle = builder.jingle;
        this.sipub = builder.sipub;
        this.setType(IQ.Type.set);
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQHoxtChildElementBuilder(IQ.IQChildElementXmlStringBuilder builder) {
        builder.attribute("method", (Enum)this.method);
        builder.attribute("resource", this.resource);
        builder.attribute("version", this.getVersion());
        builder.optIntAttribute("maxChunkSize", this.maxChunkSize);
        builder.optBooleanAttributeDefaultTrue("sipub", this.sipub);
        builder.optBooleanAttributeDefaultTrue("ibb", this.ibb);
        builder.optBooleanAttributeDefaultTrue("jingle", this.jingle);
        builder.rightAngleBracket();
        return builder;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getResource() {
        return this.resource;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public boolean isSipub() {
        return this.sipub;
    }

    public boolean isIbb() {
        return this.ibb;
    }

    public boolean isJingle() {
        return this.jingle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractHttpOverXmpp.Builder<Builder, HttpOverXmppReq> {
        private HttpMethod method;
        private String resource;
        private int maxChunkSize = -1;
        private boolean sipub = true;
        private boolean ibb = true;
        private boolean jingle = true;

        private Builder() {
        }

        public Builder setMethod(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder setJingle(boolean jingle) {
            this.jingle = jingle;
            return this;
        }

        public Builder setIbb(boolean ibb) {
            this.ibb = ibb;
            return this;
        }

        public Builder setSipub(boolean sipub) {
            this.sipub = sipub;
            return this;
        }

        public Builder setMaxChunkSize(int maxChunkSize) {
            if (maxChunkSize < 256 || maxChunkSize > 65536) {
                throw new IllegalArgumentException("maxChunkSize must be within [256, 65536]");
            }
            this.maxChunkSize = maxChunkSize;
            return this;
        }

        @Override
        public HttpOverXmppReq build() {
            if (this.method == null) {
                throw new IllegalArgumentException("Method cannot be null");
            }
            if (this.resource == null) {
                throw new IllegalArgumentException("Resource cannot be null");
            }
            return new HttpOverXmppReq(this);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

