/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.control.provider;

import java.util.ArrayList;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.iot.control.element.IoTSetRequest;
import org.jivesoftware.smackx.iot.control.element.SetBoolData;
import org.jivesoftware.smackx.iot.control.element.SetData;
import org.jivesoftware.smackx.iot.control.element.SetDoubleData;
import org.jivesoftware.smackx.iot.control.element.SetIntData;
import org.jivesoftware.smackx.iot.control.element.SetLongData;
import org.xmlpull.v1.XmlPullParser;

public class IoTSetRequestProvider
extends IQProvider<IoTSetRequest> {
    /*
     * Enabled aggressive block sorting
     */
    public IoTSetRequest parse(XmlPullParser parser, int initialDepth) throws Exception {
        ArrayList<SetData> data = new ArrayList<SetData>(4);
        while (true) {
            int eventType = parser.next();
            String name = parser.getName();
            block0 : switch (eventType) {
                case 2: {
                    switch (name) {
                        case "bool": {
                            String valueName = parser.getAttributeValue(null, "name");
                            String valueString = parser.getAttributeValue(null, "value");
                            boolean value = Boolean.parseBoolean(valueString);
                            data.add(new SetBoolData(valueName, value));
                            break block0;
                        }
                        case "double": {
                            String valueName = parser.getAttributeValue(null, "name");
                            String valueString = parser.getAttributeValue(null, "value");
                            double value = Double.parseDouble(valueString);
                            data.add(new SetDoubleData(valueName, value));
                            break block0;
                        }
                        case "int": {
                            String valueName = parser.getAttributeValue(null, "name");
                            String valueString = parser.getAttributeValue(null, "value");
                            int value = Integer.parseInt(valueString);
                            data.add(new SetIntData(valueName, value));
                            break block0;
                        }
                        case "long": {
                            String valueName = parser.getAttributeValue(null, "name");
                            String valueString = parser.getAttributeValue(null, "value");
                            long value = Long.parseLong(valueString);
                            data.add(new SetLongData(valueName, value));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new IoTSetRequest(data);
                }
            }
        }
    }
}

