/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.element;

import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class NodeInfo {
    public static final NodeInfo EMPTY = new NodeInfo();
    private final String nodeId;
    private final String sourceId;
    private final String cacheType;

    private NodeInfo() {
        this.nodeId = null;
        this.sourceId = null;
        this.cacheType = null;
    }

    public NodeInfo(String nodeId, String sourceId, String cacheType) {
        this.nodeId = (String)StringUtils.requireNotNullOrEmpty((CharSequence)nodeId, (String)"Node ID must not be null or empty");
        this.sourceId = sourceId;
        this.cacheType = cacheType;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public void appendTo(XmlStringBuilder xml) {
        if (this.nodeId == null) {
            return;
        }
        xml.attribute("nodeId", this.nodeId).optAttribute("sourceId", this.sourceId).optAttribute("cacheType", this.cacheType);
    }

    public int hashCode() {
        if (this == EMPTY) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nodeId.hashCode();
        result = 31 * result + (this.sourceId == null ? 0 : this.sourceId.hashCode());
        result = 31 * result + (this.cacheType == null ? 0 : this.cacheType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof NodeInfo)) {
            return false;
        }
        NodeInfo otherNodeInfo = (NodeInfo)other;
        if (!this.nodeId.equals(otherNodeInfo.nodeId)) {
            return false;
        }
        return StringUtils.nullSafeCharSequenceEquals((CharSequence)this.sourceId, (CharSequence)otherNodeInfo.sourceId) && StringUtils.nullSafeCharSequenceEquals((CharSequence)this.cacheType, (CharSequence)otherNodeInfo.cacheType);
    }
}

