/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.mam.element.MamPrefsIQ;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MamPrefsIQProvider
extends IQProvider<MamPrefsIQ> {
    /*
     * Enabled aggressive block sorting
     */
    public MamPrefsIQ parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
        String iqType = parser.getAttributeValue("", "type");
        String defaultBehaviorString = parser.getAttributeValue("", "default");
        MamPrefsIQ.DefaultBehavior defaultBehavior = null;
        if (defaultBehaviorString != null) {
            defaultBehavior = MamPrefsIQ.DefaultBehavior.valueOf(defaultBehaviorString);
        }
        if (iqType == null) {
            iqType = "result";
        }
        List<Jid> alwaysJids = null;
        List<Jid> neverJids = null;
        while (true) {
            int eventType = parser.next();
            String name = parser.getName();
            block0 : switch (eventType) {
                case 2: {
                    switch (name) {
                        case "always": {
                            alwaysJids = MamPrefsIQProvider.iterateJids(parser);
                            break block0;
                        }
                        case "never": {
                            neverJids = MamPrefsIQProvider.iterateJids(parser);
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new MamPrefsIQ(alwaysJids, neverJids, defaultBehavior);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<Jid> iterateJids(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<Jid> jids = new ArrayList<Jid>();
        int initialDepth = parser.getDepth();
        while (true) {
            int eventType = parser.next();
            String name = parser.getName();
            block0 : switch (eventType) {
                case 2: {
                    switch (name) {
                        case "jid": {
                            parser.next();
                            jids.add(JidCreate.from((String)parser.getText()));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return jids;
                }
            }
        }
    }
}

