/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.account;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.UtilActivator;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AccountUtils {
    private static Logger logger = Logger.getLogger(AccountUtils.class);

    public static Collection<AccountID> getStoredAccounts() {
        AccountManager accountManager = ServiceUtils.getService(UtilActivator.bundleContext, AccountManager.class);
        return accountManager.getStoredAccounts();
    }

    public static AccountID getAccountForID(String accountID) {
        Collection<AccountID> allAccounts = AccountUtils.getStoredAccounts();
        for (AccountID account : allAccounts) {
            if (!account.getAccountUniqueID().equals(accountID)) continue;
            return account;
        }
        return null;
    }

    public static List<ProtocolProviderService> getRegisteredProviders(Class<? extends OperationSet> opSetClass) {
        LinkedList<ProtocolProviderService> opSetProviders = new LinkedList<ProtocolProviderService>();
        for (ProtocolProviderFactory providerFactory : UtilActivator.getProtocolProviderFactories().values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                ProtocolProviderService protocolProvider;
                ServiceReference ref = providerFactory.getProviderForAccount(accountID);
                if (ref == null || (protocolProvider = (ProtocolProviderService)UtilActivator.bundleContext.getService(ref)).getOperationSet(opSetClass) == null || !protocolProvider.isRegistered()) continue;
                opSetProviders.add(protocolProvider);
            }
        }
        return opSetProviders;
    }

    public static List<ProtocolProviderService> getRegisteredProviders(String protocolName, Class<? extends OperationSet> opSetClass) {
        LinkedList<ProtocolProviderService> opSetProviders = new LinkedList<ProtocolProviderService>();
        ProtocolProviderFactory providerFactory = AccountUtils.getProtocolProviderFactory(protocolName);
        if (providerFactory != null) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                ProtocolProviderService protocolProvider;
                ServiceReference ref = providerFactory.getProviderForAccount(accountID);
                if (ref == null || (protocolProvider = (ProtocolProviderService)UtilActivator.bundleContext.getService(ref)).getOperationSet(opSetClass) == null || !protocolProvider.isRegistered()) continue;
                opSetProviders.add(protocolProvider);
            }
        }
        return opSetProviders;
    }

    public static List<ProtocolProviderService> getOpSetRegisteredProviders(Class<? extends OperationSet> opSet, ProtocolProviderService preferredProvider, String preferredProtocolName) {
        List<ProtocolProviderService> providers = new ArrayList<ProtocolProviderService>();
        if (preferredProvider != null) {
            if (preferredProvider.isRegistered()) {
                providers.add(preferredProvider);
            } else {
                providers = AccountUtils.getRegisteredProviders(preferredProvider.getProtocolName(), opSet);
            }
        } else {
            providers = preferredProtocolName != null ? AccountUtils.getRegisteredProviders(preferredProtocolName, opSet) : AccountUtils.getRegisteredProviders(opSet);
        }
        return providers;
    }

    public static ProtocolProviderService getRegisteredProviderForAccount(AccountID accountID) {
        for (ProtocolProviderFactory factory : UtilActivator.getProtocolProviderFactories().values()) {
            ServiceReference ref;
            if (!factory.getRegisteredAccounts().contains(accountID) || (ref = factory.getProviderForAccount(accountID)) == null) continue;
            return (ProtocolProviderService)UtilActivator.bundleContext.getService(ref);
        }
        return null;
    }

    public static ProtocolProviderFactory getProtocolProviderFactory(ProtocolProviderService protocolProvider) {
        return AccountUtils.getProtocolProviderFactory(protocolProvider.getProtocolName());
    }

    public static ProtocolProviderFactory getProtocolProviderFactory(String protocolName) {
        String osgiFilter = "(PROTOCOL_NAME=" + protocolName + ")";
        ProtocolProviderFactory protocolProviderFactory = null;
        try {
            Collection refs = UtilActivator.bundleContext.getServiceReferences(ProtocolProviderFactory.class, osgiFilter);
            if (refs != null && !refs.isEmpty()) {
                protocolProviderFactory = (ProtocolProviderFactory)UtilActivator.bundleContext.getService((ServiceReference)refs.iterator().next());
            }
        }
        catch (InvalidSyntaxException ex) {
            logger.error("AccountUtils : " + (Object)((Object)ex));
        }
        return protocolProviderFactory;
    }

    public static Collection<ProtocolProviderService> getRegisteredProviders() {
        LinkedList<ProtocolProviderService> registeredProviders = new LinkedList<ProtocolProviderService>();
        for (ProtocolProviderFactory providerFactory : UtilActivator.getProtocolProviderFactories().values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                ServiceReference ref = providerFactory.getProviderForAccount(accountID);
                if (ref == null) continue;
                ProtocolProviderService protocolProvider = (ProtocolProviderService)UtilActivator.bundleContext.getService(ref);
                registeredProviders.add(protocolProvider);
            }
        }
        return registeredProviders;
    }
}

