/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import org.jitsi.xmpp.extensions.coin.CoinIQProvider;
import org.jitsi.xmpp.extensions.coin.EndpointProvider;
import org.jitsi.xmpp.extensions.coin.StateType;
import org.jitsi.xmpp.extensions.coin.UserPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.xmlpull.v1.XmlPullParser;

public class UserProvider
extends ExtensionElementProvider {
    public UserPacketExtension parse(XmlPullParser parser, int depth) throws Exception {
        boolean done = false;
        String elementName = null;
        String entity = parser.getAttributeValue("", "entity");
        StateType state = StateType.full;
        String stateStr = parser.getAttributeValue("", "state");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        if (entity == null) {
            throw new Exception("Coin user element must contain entity attribute");
        }
        UserPacketExtension ext = new UserPacketExtension(entity);
        ext.setAttribute("state", (Object)state);
        while (!done) {
            int eventType = parser.next();
            elementName = parser.getName();
            if (eventType == 2) {
                if (elementName.equals("display-text")) {
                    ext.setDisplayText(CoinIQProvider.parseText(parser));
                    continue;
                }
                if (!elementName.equals("endpoint")) continue;
                EndpointProvider provider = new EndpointProvider();
                ExtensionElement childExtension = (ExtensionElement)provider.parse(parser);
                ext.addChildExtension(childExtension);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("user")) continue;
            done = true;
        }
        return ext;
    }
}

