/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import org.jitsi.impl.neomedia.codec.audio.g729.Util;

class Lspgetq {
    Lspgetq() {
    }

    static void lsp_get_quant(float[][] lspcb1, float[][] lspcb2, int code0, int code1, int code2, float[][] fg, float[][] freq_prev, float[] lspq, float[] fg_sum) {
        int j;
        float GAP1 = 0.0012f;
        float GAP2 = 6.0E-4f;
        int M = 10;
        int NC = 5;
        float[] buf = new float[M];
        for (j = 0; j < NC; ++j) {
            buf[j] = lspcb1[code0][j] + lspcb2[code1][j];
        }
        for (j = NC; j < M; ++j) {
            buf[j] = lspcb1[code0][j] + lspcb2[code2][j];
        }
        Lspgetq.lsp_expand_1_2(buf, GAP1);
        Lspgetq.lsp_expand_1_2(buf, GAP2);
        Lspgetq.lsp_prev_compose(buf, lspq, fg, freq_prev, fg_sum);
        Lspgetq.lsp_prev_update(buf, freq_prev);
        Lspgetq.lsp_stability(lspq);
    }

    static void lsp_expand_1(float[] buf, float gap) {
        int NC = 5;
        for (int j = 1; j < NC; ++j) {
            float diff = buf[j - 1] - buf[j];
            float tmp = (diff + gap) * 0.5f;
            if (!(tmp > 0.0f)) continue;
            int n = j - 1;
            buf[n] = buf[n] - tmp;
            int n2 = j;
            buf[n2] = buf[n2] + tmp;
        }
    }

    static void lsp_expand_2(float[] buf, float gap) {
        int NC;
        int M = 10;
        for (int j = NC = 5; j < M; ++j) {
            float diff = buf[j - 1] - buf[j];
            float tmp = (diff + gap) * 0.5f;
            if (!(tmp > 0.0f)) continue;
            int n = j - 1;
            buf[n] = buf[n] - tmp;
            int n2 = j;
            buf[n2] = buf[n2] + tmp;
        }
    }

    static void lsp_expand_1_2(float[] buf, float gap) {
        int M = 10;
        for (int j = 1; j < M; ++j) {
            float diff = buf[j - 1] - buf[j];
            float tmp = (diff + gap) * 0.5f;
            if (!(tmp > 0.0f)) continue;
            int n = j - 1;
            buf[n] = buf[n] - tmp;
            int n2 = j;
            buf[n2] = buf[n2] + tmp;
        }
    }

    private static void lsp_prev_compose(float[] lsp_ele, float[] lsp, float[][] fg, float[][] freq_prev, float[] fg_sum) {
        int M = 10;
        int MA_NP = 4;
        for (int j = 0; j < M; ++j) {
            lsp[j] = lsp_ele[j] * fg_sum[j];
            for (int k = 0; k < MA_NP; ++k) {
                int n = j;
                lsp[n] = lsp[n] + freq_prev[k][j] * fg[k][j];
            }
        }
    }

    static void lsp_prev_extract(float[] lsp, float[] lsp_ele, float[][] fg, float[][] freq_prev, float[] fg_sum_inv) {
        int M = 10;
        int MA_NP = 4;
        for (int j = 0; j < M; ++j) {
            lsp_ele[j] = lsp[j];
            for (int k = 0; k < MA_NP; ++k) {
                int n = j;
                lsp_ele[n] = lsp_ele[n] - freq_prev[k][j] * fg[k][j];
            }
            int n = j;
            lsp_ele[n] = lsp_ele[n] * fg_sum_inv[j];
        }
    }

    static void lsp_prev_update(float[] lsp_ele, float[][] freq_prev) {
        int M = 10;
        int MA_NP = 4;
        for (int k = MA_NP - 1; k > 0; --k) {
            Util.copy(freq_prev[k - 1], freq_prev[k], M);
        }
        Util.copy(lsp_ele, freq_prev[0], M);
    }

    private static void lsp_stability(float[] buf) {
        float diff;
        int j;
        float GAP3 = 0.0392f;
        float L_LIMIT = 0.005f;
        int M = 10;
        float M_LIMIT = 3.135f;
        for (j = 0; j < M - 1; ++j) {
            diff = buf[j + 1] - buf[j];
            if (!(diff < 0.0f)) continue;
            float tmp = buf[j + 1];
            buf[j + 1] = buf[j];
            buf[j] = tmp;
        }
        if (buf[0] < L_LIMIT) {
            buf[0] = L_LIMIT;
            System.out.printf("warning LSP Low \n", new Object[0]);
        }
        for (j = 0; j < M - 1; ++j) {
            diff = buf[j + 1] - buf[j];
            if (!(diff < GAP3)) continue;
            buf[j + 1] = buf[j] + GAP3;
        }
        if (buf[M - 1] > M_LIMIT) {
            buf[M - 1] = M_LIMIT;
            System.out.printf("warning LSP High \n", new Object[0]);
        }
    }
}

