/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.control.FrameProcessingControlImpl;
import org.jitsi.utils.logging.Logger;

public class SwScale
extends AbstractCodec {
    private static final Logger logger = Logger.getLogger(SwScale.class);
    public static final int MIN_SWS_SCALE_HEIGHT_OR_WIDTH = 4;
    private final boolean fixOddYuv420Size;
    private final FrameProcessingControlImpl frameProcessingControl = new FrameProcessingControlImpl();
    private final boolean preserveAspectRatio;
    private Dimension preserveAspectRatioCachedIn;
    private Dimension preserveAspectRatioCachedOut;
    private Dimension preserveAspectRatioCachedRet;
    private VideoFormat[] supportedOutputFormats = new VideoFormat[]{new RGBFormat(), new YUVFormat(2)};
    private long swsContext = 0L;

    private static int getFFmpegPixelFormat(RGBFormat rgb) {
        int pixfmt;
        block0 : switch (rgb.getBitsPerPixel()) {
            case 24: {
                pixfmt = FFmpeg.PIX_FMT_RGB24;
                break;
            }
            case 32: {
                switch (rgb.getRedMask()) {
                    case 1: 
                    case 255: {
                        pixfmt = FFmpeg.PIX_FMT_BGR32;
                        break block0;
                    }
                    case 2: 
                    case 65280: {
                        pixfmt = FFmpeg.PIX_FMT_BGR32_1;
                        break block0;
                    }
                    case 3: 
                    case 0xFF0000: {
                        pixfmt = FFmpeg.PIX_FMT_RGB32;
                        break block0;
                    }
                    case -16777216: 
                    case 4: {
                        pixfmt = FFmpeg.PIX_FMT_RGB32_1;
                        break block0;
                    }
                }
                pixfmt = -1;
                break;
            }
            default: {
                pixfmt = -1;
            }
        }
        return pixfmt;
    }

    private static VideoFormat setSize(VideoFormat format, Dimension size) {
        if (format instanceof RGBFormat) {
            RGBFormat rgbFormat = (RGBFormat)format;
            Class dataType = format.getDataType();
            int bitsPerPixel = rgbFormat.getBitsPerPixel();
            int pixelStride = rgbFormat.getPixelStride();
            if (pixelStride == -1 && dataType != null && bitsPerPixel != -1) {
                pixelStride = dataType.equals(Format.byteArray) ? bitsPerPixel / 8 : 1;
            }
            format = new RGBFormat(size, -1, dataType, format.getFrameRate(), bitsPerPixel, rgbFormat.getRedMask(), rgbFormat.getGreenMask(), rgbFormat.getBlueMask(), pixelStride, pixelStride == -1 || size == null ? -1 : pixelStride * size.width, rgbFormat.getFlipped(), rgbFormat.getEndian());
        } else if (format instanceof YUVFormat) {
            YUVFormat yuvFormat = (YUVFormat)format;
            format = new YUVFormat(size, -1, format.getDataType(), format.getFrameRate(), yuvFormat.getYuvType(), -1, -1, 0, -1, -1);
        } else if (format != null) {
            logger.warn((Object)("SwScale outputFormat of type " + format.getClass().getName() + " is not supported for optimized scaling."));
        }
        return format;
    }

    public SwScale() {
        this(false);
    }

    public SwScale(boolean fixOddYuv420Size) {
        this(fixOddYuv420Size, false);
    }

    public SwScale(boolean fixOddYuv420Size, boolean preserveAspectRatio) {
        this.fixOddYuv420Size = fixOddYuv420Size;
        this.preserveAspectRatio = preserveAspectRatio;
        this.inputFormats = new Format[]{new AVFrameFormat(), new RGBFormat(), new YUVFormat(2)};
        this.addControl((Control)this.frameProcessingControl);
    }

    public void close() {
        try {
            if (this.swsContext != 0L) {
                FFmpeg.sws_freeContext((long)this.swsContext);
                this.swsContext = 0L;
            }
        }
        finally {
            super.close();
        }
    }

    public Format getInputFormat() {
        return super.getInputFormat();
    }

    public Dimension getOutputSize() {
        Format outputFormat = this.getOutputFormat();
        if (outputFormat == null) {
            outputFormat = this.supportedOutputFormats[0];
        }
        return ((VideoFormat)outputFormat).getSize();
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.supportedOutputFormats;
        }
        Dimension size = this.supportedOutputFormats[0].getSize();
        VideoFormat videoInput = (VideoFormat)input;
        if (size == null) {
            size = videoInput.getSize();
        }
        float frameRate = videoInput.getFrameRate();
        return new Format[]{new RGBFormat(size, -1, null, frameRate, 32, -1, -1, -1), new YUVFormat(size, -1, null, frameRate, 2, -1, -1, -1, -1, -1)};
    }

    private Dimension preserveAspectRatio(Dimension in, Dimension out) {
        double widthRatio;
        double heightRatio;
        int inHeight = in.height;
        int inWidth = in.width;
        int outHeight = out.height;
        int outWidth = out.width;
        if (this.preserveAspectRatioCachedIn != null && this.preserveAspectRatioCachedOut != null && this.preserveAspectRatioCachedIn.height == inHeight && this.preserveAspectRatioCachedIn.width == inWidth && this.preserveAspectRatioCachedOut.height == outHeight && this.preserveAspectRatioCachedOut.width == outWidth && this.preserveAspectRatioCachedRet != null) {
            return this.preserveAspectRatioCachedRet;
        }
        boolean scale = false;
        if (outHeight != inHeight && outHeight > 0) {
            scale = true;
            heightRatio = (double)inHeight / (double)outHeight;
        } else {
            heightRatio = 1.0;
        }
        if (outWidth != inWidth && outWidth > 0) {
            scale = true;
            widthRatio = (double)inWidth / (double)outWidth;
        } else {
            widthRatio = 1.0;
        }
        Dimension ret = out;
        if (scale) {
            double ratio = Math.min(heightRatio, widthRatio);
            int retHeight = (int)((double)outHeight * ratio);
            int retWidth = (int)((double)outWidth * ratio);
            if (!(Math.abs(retHeight - outHeight) <= 1 && Math.abs(retWidth - outWidth) <= 1 || retHeight >= 4 && retWidth >= 4)) {
                this.preserveAspectRatioCachedRet = ret = new Dimension(retWidth, retHeight);
            }
        }
        this.preserveAspectRatioCachedIn = new Dimension(inWidth, inHeight);
        this.preserveAspectRatioCachedOut = new Dimension(outWidth, outHeight);
        if (ret == out) {
            this.preserveAspectRatioCachedRet = this.preserveAspectRatioCachedOut;
        }
        return ret;
    }

    public int process(Buffer in, Buffer out) {
        long srcPicture;
        int srcFmt;
        Object src;
        int dstLength;
        int dstFmt;
        Dimension inSize;
        Format thisInFormat;
        if (!this.checkInputBuffer(in)) {
            return 1;
        }
        if (this.isEOM(in)) {
            this.propagateEOM(out);
            return 0;
        }
        if (in.isDiscard() || this.frameProcessingControl.isMinimalProcessing()) {
            out.setDiscard(true);
            return 0;
        }
        VideoFormat inFormat = (VideoFormat)in.getFormat();
        if (inFormat != (thisInFormat = this.getInputFormat()) && !inFormat.equals((Object)thisInFormat)) {
            this.setInputFormat((Format)inFormat);
        }
        if ((inSize = inFormat.getSize()) == null) {
            return 1;
        }
        int inWidth = inSize.width;
        int inHeight = inSize.height;
        if (inWidth < 4 || inHeight < 4) {
            return 4;
        }
        VideoFormat outFormat = (VideoFormat)this.getOutputFormat();
        if (outFormat == null && (outFormat = (VideoFormat)out.getFormat()) == null) {
            return 1;
        }
        Dimension outSize = outFormat.getSize();
        if (outSize == null) {
            outSize = inSize;
        } else if (this.preserveAspectRatio) {
            outSize = this.preserveAspectRatio(inSize, outSize);
        }
        int outWidth = outSize.width;
        int outHeight = outSize.height;
        if (outWidth < 4 || outHeight < 4) {
            return 4;
        }
        if ((outFormat = SwScale.setSize(outFormat, outSize)) == null) {
            return 1;
        }
        if (outFormat instanceof RGBFormat) {
            dstFmt = SwScale.getFFmpegPixelFormat((RGBFormat)outFormat);
            dstLength = outWidth * outHeight * 4;
        } else if (outFormat instanceof YUVFormat) {
            dstFmt = 0;
            dstLength = outWidth * outHeight + 2 * ((outWidth + 1) / 2) * ((outHeight + 1) / 2);
        } else {
            return 1;
        }
        Class outDataType = outFormat.getDataType();
        Object dst = out.getData();
        if (Format.byteArray.equals(outDataType)) {
            if (dst == null || ((byte[])dst).length < dstLength) {
                dst = new byte[dstLength];
            }
        } else if (Format.intArray.equals(outDataType)) {
            dstLength = dstLength / 4 + (dstLength % 4 == 0 ? 0 : 1);
            if (dst == null || ((int[])dst).length < dstLength) {
                dst = new int[dstLength];
            }
        } else if (Format.shortArray.equals(outDataType)) {
            dstLength = dstLength / 2 + (dstLength % 2 == 0 ? 0 : 1);
            if (dst == null || ((short[])dst).length < dstLength) {
                dst = new short[dstLength];
            }
        } else {
            logger.error((Object)("Unsupported output data type " + outDataType));
            return 1;
        }
        if ((src = in.getData()) instanceof AVFrame) {
            srcFmt = ((AVFrameFormat)inFormat).getPixFmt();
            srcPicture = ((AVFrame)src).getPtr();
        } else {
            srcFmt = inFormat instanceof YUVFormat ? 0 : SwScale.getFFmpegPixelFormat((RGBFormat)inFormat);
            srcPicture = 0L;
        }
        this.swsContext = FFmpeg.sws_getCachedContext((long)this.swsContext, (int)inWidth, (int)inHeight, (int)srcFmt, (int)outWidth, (int)outHeight, (int)dstFmt, (int)4);
        if (srcPicture == 0L) {
            FFmpeg.sws_scale((long)this.swsContext, (Object)src, (int)srcFmt, (int)inWidth, (int)inHeight, (int)0, (int)inHeight, (Object)dst, (int)dstFmt, (int)outWidth, (int)outHeight);
        } else {
            FFmpeg.sws_scale((long)this.swsContext, (long)srcPicture, (int)0, (int)inHeight, (Object)dst, (int)dstFmt, (int)outWidth, (int)outHeight);
        }
        out.setData(dst);
        out.setDuration(in.getDuration());
        out.setFlags(in.getFlags());
        out.setFormat((Format)outFormat);
        out.setLength(dstLength);
        out.setOffset(0);
        out.setSequenceNumber(in.getSequenceNumber());
        out.setTimeStamp(in.getTimeStamp());
        int inFlags = in.getFlags();
        int outFlags = out.getFlags();
        if ((inFlags & 0x8000) != 0) {
            outFlags |= 0x8000;
        }
        if ((inFlags & 0x40) != 0) {
            outFlags |= 0x40;
        }
        if ((inFlags & 0x100) != 0) {
            outFlags |= 0x100;
        }
        if ((inFlags & 0x1000) != 0) {
            outFlags |= 0x1000;
        }
        if ((inFlags & 0x80) != 0) {
            outFlags |= 0x80;
        }
        out.setFlags(outFlags);
        return 0;
    }

    public Format setInputFormat(Format format) {
        Format inputFormat;
        Format format2 = inputFormat = format instanceof VideoFormat ? super.setInputFormat(format) : null;
        if (inputFormat != null && logger.isDebugEnabled()) {
            logger.debug((Object)(((Object)((Object)this)).getClass().getName() + " 0x" + Integer.toHexString(((Object)((Object)this)).hashCode()) + " set to input in " + inputFormat));
        }
        return inputFormat;
    }

    public Format setOutputFormat(Format format) {
        Format outputFormat;
        Dimension size;
        YUVFormat yuvFormat;
        if (this.fixOddYuv420Size && format instanceof YUVFormat && 2 == (yuvFormat = (YUVFormat)format).getYuvType() && (size = yuvFormat.getSize()) != null && size.width > 2 && size.height > 2) {
            int width = size.width >> 1 << 1;
            int height = size.height >> 1 << 1;
            if (width != size.width || height != size.height) {
                format = new YUVFormat(new Dimension(width, height), -1, yuvFormat.getDataType(), yuvFormat.getFrameRate(), yuvFormat.getYuvType(), -1, -1, 0, -1, -1);
            }
        }
        if ((outputFormat = super.setOutputFormat(format)) != null && logger.isDebugEnabled()) {
            logger.debug((Object)(((Object)((Object)this)).getClass().getName() + " 0x" + Integer.toHexString(((Object)((Object)this)).hashCode()) + " set to output in " + outputFormat));
        }
        return outputFormat;
    }

    private void setOutputFormatSize(Dimension size) {
        VideoFormat outputFormat = (VideoFormat)this.getOutputFormat();
        if (outputFormat != null && (outputFormat = SwScale.setSize(outputFormat, size)) != null) {
            this.setOutputFormat((Format)outputFormat);
        }
    }

    public void setOutputSize(Dimension size) {
        if (size != null && (size.height < 4 || size.width < 4)) {
            return;
        }
        for (int i = 0; i < this.supportedOutputFormats.length; ++i) {
            this.supportedOutputFormats[i] = SwScale.setSize(this.supportedOutputFormats[i], size);
        }
        this.setOutputFormatSize(size);
    }
}

