/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.quicktime;

import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import java.util.Vector;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.PlugInManager;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.control.FrameRateControlAdapter;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPushBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.quicktime.QuickTimeStream;
import org.jitsi.impl.neomedia.quicktime.NSErrorException;
import org.jitsi.impl.neomedia.quicktime.QTCaptureDevice;
import org.jitsi.impl.neomedia.quicktime.QTCaptureDeviceInput;
import org.jitsi.impl.neomedia.quicktime.QTCaptureSession;
import org.jitsi.utils.logging.Logger;

public class DataSource
extends AbstractVideoPushBufferCaptureDevice {
    private static final Logger logger = Logger.getLogger(DataSource.class);
    private QTCaptureSession captureSession;
    private QTCaptureDevice device;
    private static Format[] supportedFormats;

    public DataSource() {
        this(null);
    }

    public DataSource(MediaLocator locator) {
        super(locator);
    }

    @Override
    protected FrameRateControl createFrameRateControl() {
        return new FrameRateControlAdapter(){
            private float frameRate = -1.0f;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getFrameRate() {
                float frameRate = -1.0f;
                boolean frameRateFromQuickTimeStream = false;
                Object object = DataSource.this.getStreamSyncRoot();
                synchronized (object) {
                    AbstractBufferStream[] streams = DataSource.this.streams();
                    if (streams != null && streams.length != 0) {
                        for (AbstractBufferStream stream : streams) {
                            QuickTimeStream quickTimeStream = (QuickTimeStream)stream;
                            if (quickTimeStream == null) continue;
                            frameRate = quickTimeStream.getFrameRate();
                            frameRateFromQuickTimeStream = true;
                            if (frameRate != -1.0f) break;
                        }
                    }
                }
                return frameRateFromQuickTimeStream ? frameRate : this.frameRate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float setFrameRate(float frameRate) {
                float setFrameRate = -1.0f;
                boolean frameRateFromQuickTimeStream = false;
                Object object = DataSource.this.getStreamSyncRoot();
                synchronized (object) {
                    AbstractBufferStream[] streams = DataSource.this.streams();
                    if (streams != null && streams.length != 0) {
                        for (AbstractBufferStream stream : streams) {
                            QuickTimeStream quickTimeStream = (QuickTimeStream)stream;
                            if (quickTimeStream == null) continue;
                            float quickTimeStreamFrameRate = quickTimeStream.setFrameRate(frameRate);
                            if (quickTimeStreamFrameRate != -1.0f) {
                                setFrameRate = quickTimeStreamFrameRate;
                            }
                            frameRateFromQuickTimeStream = true;
                        }
                    }
                }
                if (frameRateFromQuickTimeStream) {
                    return setFrameRate;
                }
                this.frameRate = frameRate;
                return this.frameRate;
            }
        };
    }

    protected QuickTimeStream createStream(int streamIndex, FormatControl formatControl) {
        QuickTimeStream stream = new QuickTimeStream(this, formatControl);
        if (this.captureSession != null) {
            try {
                this.captureSession.addOutput(stream.captureOutput);
            }
            catch (NSErrorException nseex) {
                logger.error((Object)"Failed to addOutput to QTCaptureSession", (Throwable)nseex);
                throw new UndeclaredThrowableException(nseex);
            }
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConnect() throws IOException {
        boolean deviceIsOpened;
        super.doConnect();
        try {
            deviceIsOpened = this.device.open();
        }
        catch (NSErrorException nseex) {
            IOException ioex = new IOException();
            ioex.initCause(nseex);
            throw ioex;
        }
        if (!deviceIsOpened) {
            throw new IOException("Failed to open QTCaptureDevice");
        }
        QTCaptureDeviceInput deviceInput = QTCaptureDeviceInput.deviceInputWithDevice(this.device);
        this.captureSession = new QTCaptureSession();
        try {
            this.captureSession.addInput(deviceInput);
        }
        catch (NSErrorException nseex) {
            IOException ioex = new IOException();
            ioex.initCause(nseex);
            throw ioex;
        }
        Object object = this.getStreamSyncRoot();
        synchronized (object) {
            AbstractBufferStream<?>[] streams = this.streams();
            if (streams != null) {
                for (AbstractBufferStream<?> stream : streams) {
                    if (stream == null) continue;
                    try {
                        this.captureSession.addOutput(((QuickTimeStream)stream).captureOutput);
                    }
                    catch (NSErrorException nseex) {
                        logger.error((Object)"Failed to addOutput to QTCaptureSession", (Throwable)nseex);
                        IOException ioex = new IOException();
                        ioex.initCause(nseex);
                        throw ioex;
                    }
                }
            }
        }
    }

    @Override
    protected void doDisconnect() {
        super.doDisconnect();
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        this.device.close();
    }

    @Override
    protected void doStart() throws IOException {
        this.captureSession.startRunning();
        super.doStart();
    }

    @Override
    protected void doStop() throws IOException {
        super.doStop();
        this.captureSession.stopRunning();
    }

    @Override
    protected Format[] getSupportedFormats(int streamIndex) {
        return DataSource.getSupportedFormats(super.getSupportedFormats(streamIndex));
    }

    private static synchronized Format[] getSupportedFormats(Format[] genericFormats) {
        if (supportedFormats != null && supportedFormats.length > 0) {
            return (Format[])supportedFormats.clone();
        }
        LinkedList<Format> specificFormats = new LinkedList<Format>();
        for (Format genericFormat : genericFormats) {
            VideoFormat genericVideoFormat = (VideoFormat)genericFormat;
            if (genericVideoFormat.getSize() == null) {
                Vector codecs = PlugInManager.getPlugInList((Format)new VideoFormat(genericVideoFormat.getEncoding()), null, (int)2);
                for (String codec : codecs) {
                    Format[] supportedInputFormats;
                    for (Format supportedInputFormat : supportedInputFormats = PlugInManager.getSupportedInputFormats((String)codec, (int)2)) {
                        Dimension size;
                        if (!(supportedInputFormat instanceof VideoFormat) || (size = ((VideoFormat)supportedInputFormat).getSize()) == null) continue;
                        specificFormats.add(genericFormat.intersects((Format)new VideoFormat(null, size, -1, null, -1.0f)));
                    }
                }
            }
            specificFormats.add(genericFormat);
        }
        supportedFormats = specificFormats.toArray(new Format[specificFormats.size()]);
        return (Format[])supportedFormats.clone();
    }

    private void setDevice(QTCaptureDevice device) {
        if (this.device != device) {
            this.device = device;
        }
    }

    @Override
    protected Format setFormat(int streamIndex, Format oldValue, Format newValue) {
        if (newValue instanceof VideoFormat) {
            return newValue;
        }
        return super.setFormat(streamIndex, oldValue, newValue);
    }

    public void setLocator(MediaLocator locator) {
        QTCaptureDevice device;
        super.setLocator(locator);
        locator = this.getLocator();
        if (locator != null && "quicktime".equalsIgnoreCase(locator.getProtocol())) {
            String deviceUID = locator.getRemainder();
            device = QTCaptureDevice.deviceWithUniqueID(deviceUID);
        } else {
            device = null;
        }
        this.setDevice(device);
    }
}

