/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.stats.RateStatistics;

public class RTPEncodingDesc {
    public static final int SUSPENDED_INDEX = -1;
    private static final Logger logger = Logger.getLogger(RTPEncodingDesc.class);
    private static final int NO_HEIGHT = -1;
    private static final double NO_FRAME_RATE = -1.0;
    private static final int AVERAGE_BITRATE_WINDOW_MS = 5000;
    private static final int FRAMES_HISTORY_SZ = 60;
    private static final int SUSPENSION_THRESHOLD_MS = 300;
    private final long primarySSRC;
    private final Map<Long, String> secondarySsrcs = new HashMap<Long, String>();
    private final int idx;
    private final int tid;
    private final int sid;
    private final int height;
    private final double frameRate;
    private final RTPEncodingDesc base;
    private final MediaStreamTrackDesc track;
    private final RateStatistics rateStatistics = new RateStatistics(5000);
    private final RTPEncodingDesc[] dependencyEncodings;
    private AtomicInteger numOfReceivers = new AtomicInteger();

    public RTPEncodingDesc(MediaStreamTrackDesc track, long primarySSRC) {
        this(track, 0, primarySSRC, -1, -1, -1, -1.0, null);
    }

    public RTPEncodingDesc(MediaStreamTrackDesc track, int idx, long primarySSRC, int tid, int sid, int height, double frameRate, RTPEncodingDesc[] dependencyEncodings) {
        this.height = height;
        this.frameRate = frameRate;
        this.primarySSRC = primarySSRC;
        this.track = track;
        this.idx = idx;
        this.tid = tid;
        this.sid = sid;
        this.dependencyEncodings = dependencyEncodings;
        this.base = ArrayUtils.isNullOrEmpty((Object[])dependencyEncodings) ? this : dependencyEncodings[0].getBaseLayer();
    }

    public void addSecondarySsrc(long ssrc, String type) {
        this.secondarySsrcs.put(ssrc, type);
    }

    public long getLastStableBitrateBps(long nowMs) {
        return this.rateStatistics.getRate(nowMs);
    }

    public long getPrimarySSRC() {
        return this.primarySSRC;
    }

    public long getSecondarySsrc(String type) {
        for (Map.Entry<Long, String> e : this.secondarySsrcs.entrySet()) {
            if (!e.getValue().equals(type)) continue;
            return e.getKey();
        }
        return -1L;
    }

    public String toString() {
        return "subjective_quality=" + this.idx + ",primary_ssrc=" + this.getPrimarySSRC() + ",secondary_ssrcs=" + this.secondarySsrcs + ",temporal_id=" + this.tid + ",spatial_id=" + this.sid;
    }

    public MediaStreamTrackDesc getMediaStreamTrack() {
        return this.track;
    }

    public int getIndex() {
        return this.idx;
    }

    public boolean requires(int idx) {
        if (idx < 0) {
            return false;
        }
        if (idx == this.idx) {
            return true;
        }
        boolean requires = false;
        if (!ArrayUtils.isNullOrEmpty((Object[])this.dependencyEncodings)) {
            for (RTPEncodingDesc enc : this.dependencyEncodings) {
                if (!enc.requires(idx)) continue;
                requires = true;
                break;
            }
        }
        return requires;
    }

    boolean matches(RawPacket pkt) {
        long ssrc = pkt.getSSRCAsLong();
        if (!this.matches(ssrc)) {
            return false;
        }
        if (this.tid == -1 && this.sid == -1) {
            return true;
        }
        int tid = this.tid != -1 ? this.track.getMediaStreamTrackReceiver().getStream().getTemporalID(pkt) : -1;
        int sid = this.sid != -1 ? this.track.getMediaStreamTrackReceiver().getStream().getSpatialID(pkt) : -1;
        return tid == -1 && sid == -1 && this.idx == 0 || tid == this.tid && sid == this.sid;
    }

    public boolean matches(long ssrc) {
        if (this.primarySSRC == ssrc) {
            return true;
        }
        return this.secondarySsrcs.containsKey(ssrc);
    }

    void update(RawPacket pkt, long nowMs) {
        this.rateStatistics.update(pkt.getLength(), nowMs);
    }

    private long getBitrateBps(long nowMs) {
        Object[] encodings = this.track.getRTPEncodings();
        if (ArrayUtils.isNullOrEmpty((Object[])encodings)) {
            return 0L;
        }
        long[] rates = new long[encodings.length];
        this.getBitrateBps(nowMs, rates);
        long bitrate = 0L;
        for (int i = 0; i < rates.length; ++i) {
            bitrate += rates[i];
        }
        return bitrate;
    }

    private void getBitrateBps(long nowMs, long[] rates) {
        if (rates[this.idx] == 0L) {
            rates[this.idx] = this.rateStatistics.getRate(nowMs);
        }
        if (!ArrayUtils.isNullOrEmpty((Object[])this.dependencyEncodings)) {
            for (RTPEncodingDesc dependency : this.dependencyEncodings) {
                dependency.getBitrateBps(nowMs, rates);
            }
        }
    }

    public RTPEncodingDesc getBaseLayer() {
        return this.base;
    }

    public int getHeight() {
        return this.height;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public boolean isReceived() {
        return this.numOfReceivers.get() > 0;
    }
}

