/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.logging.Logger;

public class OriginalHeaderBlockTransformEngine
extends SinglePacketTransformerAdapter
implements TransformEngine {
    private static final Logger logger = Logger.getLogger(OriginalHeaderBlockTransformEngine.class);
    private int extensionID = -1;

    public OriginalHeaderBlockTransformEngine() {
        super(RTPPacketPredicate.INSTANCE);
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        if (this.extensionID != -1) {
            this.addExtension(pkt);
        }
        return pkt;
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        return pkt;
    }

    private void rebuildOhb(RawPacket pkt, RawPacket.HeaderExtension ohb) {
        long origSsrc;
        long origTs;
        int origSeq;
        byte[] buf = ohb.getBuffer();
        int off = ohb.getOffset();
        int len = ohb.getExtLength();
        if (len != 11) {
            logger.warn((Object)"Unexpected OHB length.");
            return;
        }
        byte pt = pkt.getPayloadType();
        int seq = pkt.getSequenceNumber();
        long ts = pkt.getTimestamp();
        long ssrc = pkt.getSSRCAsLong();
        byte origPt = buf[off + 1];
        int newLen = this.getLength(pt != origPt, seq != (origSeq = RTPUtils.readUint16AsInt(buf, off + 2)), ts != (origTs = RTPUtils.readUint32AsLong(buf, off + 4)), ssrc != (origSsrc = RTPUtils.readUint32AsLong(buf, off + 8)));
        if (newLen != len) {
            // empty if block
        }
    }

    private int getLength(boolean pt, boolean seq, boolean ts, boolean ssrc) {
        if (!(pt || seq || ts || ssrc)) {
            return 0;
        }
        if (pt && !seq && !ts && !ssrc) {
            return 1;
        }
        if (!pt && seq && !ts && !ssrc) {
            return 2;
        }
        if (!pt && !seq && ts && !ssrc) {
            return 4;
        }
        if (!pt && !seq && !ts && ssrc) {
            return 5;
        }
        if (pt && seq && !ts && !ssrc) {
            return 3;
        }
        if (pt && !seq && ts && !ssrc) {
            return 5;
        }
        if (pt && !seq && !ts && ssrc) {
            return 5;
        }
        if (!pt && seq && ts && !ssrc) {
            return 6;
        }
        if (!pt && seq && !ts && ssrc) {
            return 7;
        }
        if (!pt && !seq && ts && ssrc) {
            return 8;
        }
        if (pt && seq && ts && !ssrc) {
            return 7;
        }
        if (pt && seq && !ts && ssrc) {
            return 7;
        }
        if (pt && !seq && ts && ssrc) {
            return 9;
        }
        if (!pt && seq && ts && ssrc) {
            return 10;
        }
        if (pt && seq && ts && ssrc) {
            return 11;
        }
        throw new IllegalStateException();
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    private void addExtension(RawPacket pkt) {
        RawPacket.HeaderExtension he = pkt.addExtension((byte)this.extensionID, 11);
        byte[] buf = he.getBuffer();
        int off = he.getOffset();
        buf[off + 1] = pkt.getPayloadType();
        RTPUtils.writeShort(buf, off + 2, (short)pkt.getSequenceNumber());
        RTPUtils.writeInt(buf, off + 4, (int)pkt.getTimestamp());
        RTPUtils.writeInt(buf, off + 8, pkt.getSSRC());
    }

    public void setExtensionID(int id) {
        this.extensionID = id;
    }
}

